/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.factory.VersionServiceFactory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.versioning.service.VersioningService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VersioningTest
extends AbstractUnitTest {
    private static final Logger log = LogManager.getLogger(VersioningTest.class);
    private Item originalItem;
    private Item versionedItem;
    private String summary = "Unit test version";
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected VersioningService versionService = VersionServiceFactory.getInstance().getVersionService();
    protected VersionHistoryService versionHistoryService = VersionServiceFactory.getInstance().getVersionHistoryService();

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            Community community = this.communityService.create(null, this.context);
            Collection col = this.collectionService.create(this.context, community);
            WorkspaceItem is = this.workspaceItemService.create(this.context, col, false);
            this.originalItem = this.installItemService.installItem(this.context, (InProgressSubmission)is);
            Version version = this.versionService.createNewVersion(this.context, this.originalItem, this.summary);
            WorkspaceItem wsi = this.workspaceItemService.findByItem(this.context, version.getItem());
            this.versionedItem = this.installItemService.installItem(this.context, (InProgressSubmission)wsi);
            this.context.restoreAuthSystemState();
        }
        catch (AuthorizeException ex) {
            log.error("Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error("SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.context.abort();
        super.destroy();
    }

    @Test
    public void testVersionFind() throws SQLException {
        VersionHistory versionHistory = this.versionHistoryService.findByItem(this.context, this.originalItem);
        MatcherAssert.assertThat((String)"testFindVersionHistory", (Object)versionHistory, (Matcher)CoreMatchers.notNullValue());
        Version version = this.versionHistoryService.getVersion(this.context, versionHistory, this.versionedItem);
        MatcherAssert.assertThat((String)"testFindVersion", (Object)version, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testVersionSummary() throws Exception {
        VersionHistory versionHistory = this.versionHistoryService.findByItem(this.context, this.originalItem);
        Version version = this.versionHistoryService.getVersion(this.context, versionHistory, this.versionedItem);
        MatcherAssert.assertThat((String)"Test_version_summary", (Object)this.summary, (Matcher)CoreMatchers.equalTo((Object)version.getSummary()));
    }

    @Test
    public void testVersionHandle() throws Exception {
        MatcherAssert.assertThat((String)"Test_version_handle 1", (Object)this.versionedItem.getHandle(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"Test_version_handle 2", (Object)this.originalItem.getHandle(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"Test_version_handle 3 ", (this.originalItem.getHandles().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testVersionDelete() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String handle = this.versionedItem.getHandle();
        this.versionService.removeVersion(this.context, this.versionedItem);
        MatcherAssert.assertThat((String)"Test_version_delete", (Object)((Item)this.itemService.find(this.context, this.versionedItem.getID())), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((String)"Test_version_handle_delete", (Object)this.handleService.resolveToObject(this.context, handle), (Matcher)CoreMatchers.nullValue());
        this.context.restoreAuthSystemState();
    }
}

