/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.authority;

import java.io.IOException;
import org.dspace.AbstractDSpaceTest;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.Choices;
import org.dspace.content.authority.DSpaceControlledVocabulary;
import org.dspace.core.factory.CoreServiceFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DSpaceControlledVocabularyTest
extends AbstractDSpaceTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetMatches() throws IOException, ClassNotFoundException {
        System.out.println("getMatches");
        String PLUGIN_INTERFACE = "org.dspace.content.authority.ChoiceAuthority";
        String text = "north 40";
        int start = 0;
        int limit = 10;
        String locale = null;
        DSpaceControlledVocabulary instance = (DSpaceControlledVocabulary)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(Class.forName("org.dspace.content.authority.ChoiceAuthority"), "farm");
        Assert.assertNotNull((Object)instance);
        Choices result = instance.getMatches(text, start, limit, locale);
        Assert.assertEquals((Object)"north 40", (Object)result.values[0].value);
    }

    @Test
    public void testGetMatchesNoLocale() throws ClassNotFoundException {
        String PLUGIN_INTERFACE = "org.dspace.content.authority.ChoiceAuthority";
        String idValue = "DZA";
        String labelPart = "Alge";
        int start = 0;
        int limit = 10;
        DSpaceControlledVocabulary instance = (DSpaceControlledVocabulary)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(Class.forName("org.dspace.content.authority.ChoiceAuthority"), "countries");
        Assert.assertNotNull((Object)instance);
        Choices result = instance.getMatches(labelPart, start, limit, null);
        Assert.assertEquals((Object)idValue, (Object)result.values[0].value);
        Assert.assertEquals((Object)"Algeria", (Object)result.values[0].label);
    }

    @Test
    public void testGetBestMatchIdValueNoLocale() throws ClassNotFoundException {
        String PLUGIN_INTERFACE = "org.dspace.content.authority.ChoiceAuthority";
        String idValue = "DZA";
        DSpaceControlledVocabulary instance = (DSpaceControlledVocabulary)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(Class.forName("org.dspace.content.authority.ChoiceAuthority"), "countries");
        Assert.assertNotNull((Object)instance);
        Choices result = instance.getBestMatch(idValue, null);
        Assert.assertEquals((Object)idValue, (Object)result.values[0].value);
        Assert.assertEquals((Object)"Algeria", (Object)result.values[0].label);
    }

    @Test
    public void testGetMatchesGermanLocale() throws ClassNotFoundException {
        String PLUGIN_INTERFACE = "org.dspace.content.authority.ChoiceAuthority";
        String idValue = "DZA";
        String labelPart = "Alge";
        int start = 0;
        int limit = 10;
        DSpaceControlledVocabulary instance = (DSpaceControlledVocabulary)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(Class.forName("org.dspace.content.authority.ChoiceAuthority"), "countries");
        Assert.assertNotNull((Object)instance);
        Choices result = instance.getMatches(labelPart, start, limit, "de");
        Assert.assertEquals((Object)idValue, (Object)result.values[0].value);
        Assert.assertEquals((Object)"Algerien", (Object)result.values[0].label);
    }

    @Test
    public void testGetBestMatchIdValueGermanLocale() throws ClassNotFoundException {
        String PLUGIN_INTERFACE = "org.dspace.content.authority.ChoiceAuthority";
        String idValue = "DZA";
        DSpaceControlledVocabulary instance = (DSpaceControlledVocabulary)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(Class.forName("org.dspace.content.authority.ChoiceAuthority"), "countries");
        Assert.assertNotNull((Object)instance);
        Choices result = instance.getBestMatch(idValue, "de");
        Assert.assertEquals((Object)idValue, (Object)result.values[0].value);
        Assert.assertEquals((Object)"Algerien", (Object)result.values[0].label);
    }

    @Test
    public void testGetChoiceNoLocale() throws ClassNotFoundException {
        String PLUGIN_INTERFACE = "org.dspace.content.authority.ChoiceAuthority";
        String idValue = "DZA";
        DSpaceControlledVocabulary instance = (DSpaceControlledVocabulary)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(Class.forName("org.dspace.content.authority.ChoiceAuthority"), "countries");
        Assert.assertNotNull((Object)instance);
        Choice result = instance.getChoice(idValue, null);
        Assert.assertEquals((Object)idValue, (Object)result.value);
        Assert.assertEquals((Object)"Algeria", (Object)result.label);
    }

    @Test
    public void testGetChoiceGermanLocale() throws ClassNotFoundException {
        String PLUGIN_INTERFACE = "org.dspace.content.authority.ChoiceAuthority";
        String idValue = "DZA";
        DSpaceControlledVocabulary instance = (DSpaceControlledVocabulary)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(Class.forName("org.dspace.content.authority.ChoiceAuthority"), "countries");
        Assert.assertNotNull((Object)instance);
        Choice result = instance.getChoice(idValue, "de");
        Assert.assertEquals((Object)idValue, (Object)result.value);
        Assert.assertEquals((Object)"Algerien", (Object)result.label);
    }
}

