/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.util.List;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.builder.CommunityBuilder;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.junit.Assert;
import org.junit.Test;

public class ContextIT
extends AbstractIntegrationTestWithDatabase {
    AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();

    @Test
    public void testGetPoliciesNewCommunityAfterReadOnlyModeChange() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.context.setDispatcher("noindex");
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        this.context.restoreAuthSystemState();
        this.context.setMode(Context.Mode.READ_ONLY);
        List policies = this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)this.parentCommunity, 0);
        Assert.assertEquals((String)"Should return the default anonymous group read policy", (long)1L, (long)policies.size());
    }
}

