/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.dspace.AbstractUnitTest;
import org.dspace.core.Utils;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class UtilsTest
extends AbstractUnitTest {
    @Test
    public void testGetBaseUrl() {
        Assert.assertEquals((String)"Test remove /server", (Object)"http://dspace.org", (Object)Utils.getBaseUrl((String)"http://dspace.org/server"));
        Assert.assertEquals((String)"Test remove /server/api/core/items", (Object)"https://dspace.org", (Object)Utils.getBaseUrl((String)"https://dspace.org/server/api/core/items"));
        Assert.assertEquals((String)"Test remove trailing slash", (Object)"https://dspace.org", (Object)Utils.getBaseUrl((String)"https://dspace.org/"));
        Assert.assertEquals((String)"Test keep url", (Object)"https://demo.dspace.org", (Object)Utils.getBaseUrl((String)"https://demo.dspace.org"));
        Assert.assertEquals((String)"Test keep url", (Object)"http://localhost:8080", (Object)Utils.getBaseUrl((String)"http://localhost:8080"));
        Assert.assertEquals((String)"Test keep url", (Object)"http://localhost:8080", (Object)Utils.getBaseUrl((String)"http://localhost:8080/server"));
        Assert.assertNull((String)"Test invalid URI returns null", (Object)Utils.getBaseUrl((String)"&+,?/@="));
    }

    @Test
    public void testGetHostName() {
        Assert.assertEquals((String)"Test remove HTTP", (Object)"dspace.org", (Object)Utils.getHostName((String)"http://dspace.org"));
        Assert.assertEquals((String)"Test remove HTTPS", (Object)"dspace.org", (Object)Utils.getHostName((String)"https://dspace.org"));
        Assert.assertEquals((String)"Test remove trailing slash", (Object)"dspace.org", (Object)Utils.getHostName((String)"https://dspace.org/"));
        Assert.assertEquals((String)"Test remove www.", (Object)"dspace.org", (Object)Utils.getHostName((String)"https://www.dspace.org"));
        Assert.assertEquals((String)"Test keep other prefixes", (Object)"demo.dspace.org", (Object)Utils.getHostName((String)"https://demo.dspace.org"));
        Assert.assertEquals((String)"Test with parameter", (Object)"demo.dspace.org", (Object)Utils.getHostName((String)"https://demo.dspace.org/search?query=test"));
        Assert.assertEquals((String)"Test with parameter with space", (Object)"demo.dspace.org", (Object)Utils.getHostName((String)"https://demo.dspace.org/search?query=test turbine"));
        Assert.assertNull((String)"Test invalid URI returns null", (Object)Utils.getHostName((String)"&+,?/@="));
    }

    @Test
    public void testGetIPAddresses() throws UnknownHostException {
        String fakeUrl = "https://dspace.org";
        String fakeHostname = "dspace.org";
        InetAddress[] fakeInetAddresses = new InetAddress[]{InetAddress.getByName("1.2.3.4"), InetAddress.getByName("5.6.7.8")};
        try (MockedStatic mockedInetAddress = Mockito.mockStatic(InetAddress.class);){
            mockedInetAddress.when(() -> InetAddress.getAllByName(fakeHostname)).thenReturn((Object)fakeInetAddresses);
            Assert.assertNull((String)"Test invalid URL returns null", (Object)Utils.getIPAddresses((String)"not/a-real;url"));
            Assert.assertArrayEquals((String)"Test fake URL returns fake IPs converted to String Array", (Object[])new String[]{"1.2.3.4", "5.6.7.8"}, (Object[])Utils.getIPAddresses((String)fakeUrl));
        }
    }

    @Test
    public void testInterpolateConfigsInString() {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        String configName = "not.a.dspace.config.at.all";
        String configValue = "demo.dspace.org";
        configurationService.setProperty(configName, (Object)configValue);
        String stringWithVariable = "The config " + configName + " has a value of ${" + configName + "}!";
        String expectedValue = "The config " + configName + " has a value of " + configValue + "!";
        Assert.assertEquals((String)"Test config interpolation", (Object)expectedValue, (Object)Utils.interpolateConfigsInString((String)stringWithVariable));
        configurationService.setProperty(configName, null);
    }
}

