/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.util.Collections;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.DiscoverResultItemIterator;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.indexobject.IndexableClaimedTask;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.discovery.indexobject.IndexablePoolTask;
import org.dspace.discovery.indexobject.IndexableWorkflowItem;
import org.dspace.discovery.indexobject.IndexableWorkspaceItem;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class DiscoverResultItemIteratorTest {
    private Context mockContext;
    private DiscoverQuery mockDiscoverQuery;
    private SearchService mockSearchService;
    private DiscoverResult mockDiscoverResult;
    private IndexableItem mockIndexableItem;
    private IndexableWorkflowItem mockIndexableWorkflowItem;
    private IndexableWorkspaceItem mockIndexableWorkspaceItem;
    private IndexablePoolTask mockIndexablePoolTask;
    private IndexableClaimedTask mockIndexableClaimedTask;
    private Item mockItem;
    private XmlWorkflowItem mockWorkflowItem;
    private WorkspaceItem mockWorkspaceItem;
    private PoolTask mockPoolTask;
    private ClaimedTask mockClaimedTask;

    @Before
    public void setUp() throws Exception {
        this.mockContext = (Context)Mockito.mock(Context.class);
        this.mockDiscoverQuery = (DiscoverQuery)Mockito.mock(DiscoverQuery.class);
        this.mockSearchService = (SearchService)Mockito.mock(SearchService.class);
        this.mockIndexableItem = (IndexableItem)Mockito.mock(IndexableItem.class);
        this.mockIndexableWorkflowItem = (IndexableWorkflowItem)Mockito.mock(IndexableWorkflowItem.class);
        this.mockIndexableWorkspaceItem = (IndexableWorkspaceItem)Mockito.mock(IndexableWorkspaceItem.class);
        this.mockIndexablePoolTask = (IndexablePoolTask)Mockito.mock(IndexablePoolTask.class);
        this.mockIndexableClaimedTask = (IndexableClaimedTask)Mockito.mock(IndexableClaimedTask.class);
        this.mockItem = (Item)Mockito.mock(Item.class);
        this.mockWorkflowItem = (XmlWorkflowItem)Mockito.mock(XmlWorkflowItem.class);
        Mockito.when((Object)this.mockWorkflowItem.getItem()).thenReturn((Object)this.mockItem);
        this.mockWorkspaceItem = (WorkspaceItem)Mockito.mock(WorkspaceItem.class);
        Mockito.when((Object)this.mockWorkspaceItem.getItem()).thenReturn((Object)this.mockItem);
        this.mockPoolTask = (PoolTask)Mockito.mock(PoolTask.class);
        Mockito.when((Object)this.mockPoolTask.getWorkflowItem()).thenReturn((Object)this.mockWorkflowItem);
        this.mockClaimedTask = (ClaimedTask)Mockito.mock(ClaimedTask.class);
        Mockito.when((Object)this.mockClaimedTask.getWorkflowItem()).thenReturn((Object)this.mockWorkflowItem);
        Mockito.when((Object)((Item)this.mockIndexableItem.getIndexedObject())).thenReturn((Object)this.mockItem);
        Mockito.when((Object)this.mockIndexableItem.getType()).thenReturn((Object)IndexableItem.TYPE);
        Mockito.when((Object)((XmlWorkflowItem)this.mockIndexableWorkflowItem.getIndexedObject())).thenReturn((Object)this.mockWorkflowItem);
        Mockito.when((Object)this.mockIndexableWorkflowItem.getType()).thenReturn((Object)IndexableWorkflowItem.TYPE);
        Mockito.when((Object)((WorkspaceItem)this.mockIndexableWorkspaceItem.getIndexedObject())).thenReturn((Object)this.mockWorkspaceItem);
        Mockito.when((Object)this.mockIndexableWorkspaceItem.getType()).thenReturn((Object)IndexableWorkspaceItem.TYPE);
        Mockito.when((Object)this.mockIndexablePoolTask.getIndexedObject()).thenReturn((Object)this.mockPoolTask);
        Mockito.when((Object)this.mockIndexablePoolTask.getType()).thenReturn((Object)IndexablePoolTask.TYPE);
        Mockito.when((Object)this.mockIndexableClaimedTask.getIndexedObject()).thenReturn((Object)this.mockClaimedTask);
        Mockito.when((Object)this.mockIndexableClaimedTask.getType()).thenReturn((Object)IndexableClaimedTask.TYPE);
    }

    @Test
    public void testNextWithIndexableItem() throws SearchServiceException {
        this.mockDiscoverResult = (DiscoverResult)Mockito.mock(DiscoverResult.class);
        Mockito.when((Object)this.mockDiscoverResult.getIndexableObjects()).thenReturn(Collections.singletonList(this.mockIndexableItem));
        Mockito.when((Object)this.mockDiscoverResult.getTotalSearchResults()).thenReturn((Object)2L);
        Mockito.when((Object)this.mockSearchService.search((Context)Mockito.eq((Object)this.mockContext), (DiscoverQuery)Mockito.any(DiscoverQuery.class))).thenReturn((Object)this.mockDiscoverResult);
        try (MockedStatic mockedStatic = Mockito.mockStatic(SearchUtils.class);){
            mockedStatic.when(SearchUtils::getSearchService).thenReturn((Object)this.mockSearchService);
            DiscoverResultItemIterator iterator = new DiscoverResultItemIterator(this.mockContext, this.mockDiscoverQuery);
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)this.mockItem, (Object)iterator.next());
        }
    }

    @Test
    public void testNextWithIndexableWorkflowItem() throws SearchServiceException {
        this.mockDiscoverResult = (DiscoverResult)Mockito.mock(DiscoverResult.class);
        Mockito.when((Object)this.mockDiscoverResult.getIndexableObjects()).thenReturn(Collections.singletonList(this.mockIndexableWorkflowItem));
        Mockito.when((Object)this.mockDiscoverResult.getTotalSearchResults()).thenReturn((Object)2L);
        Mockito.when((Object)this.mockSearchService.search((Context)Mockito.eq((Object)this.mockContext), (DiscoverQuery)Mockito.any(DiscoverQuery.class))).thenReturn((Object)this.mockDiscoverResult);
        try (MockedStatic mockedStatic = Mockito.mockStatic(SearchUtils.class);){
            mockedStatic.when(SearchUtils::getSearchService).thenReturn((Object)this.mockSearchService);
            DiscoverResultItemIterator iterator = new DiscoverResultItemIterator(this.mockContext, this.mockDiscoverQuery);
            iterator.next();
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)this.mockItem, (Object)iterator.next());
        }
    }

    @Test
    public void testNextWithIndexableWorkspaceItem() throws SearchServiceException {
        this.mockDiscoverResult = (DiscoverResult)Mockito.mock(DiscoverResult.class);
        Mockito.when((Object)this.mockDiscoverResult.getIndexableObjects()).thenReturn(Collections.singletonList(this.mockIndexableWorkspaceItem));
        Mockito.when((Object)this.mockDiscoverResult.getTotalSearchResults()).thenReturn((Object)2L);
        Mockito.when((Object)this.mockSearchService.search((Context)Mockito.eq((Object)this.mockContext), (DiscoverQuery)Mockito.any(DiscoverQuery.class))).thenReturn((Object)this.mockDiscoverResult);
        try (MockedStatic mockedStatic = Mockito.mockStatic(SearchUtils.class);){
            mockedStatic.when(SearchUtils::getSearchService).thenReturn((Object)this.mockSearchService);
            DiscoverResultItemIterator iterator = new DiscoverResultItemIterator(this.mockContext, this.mockDiscoverQuery);
            iterator.next();
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)this.mockItem, (Object)iterator.next());
        }
    }

    @Test
    public void testNextWithIndexablePoolTask() throws SearchServiceException {
        this.mockDiscoverResult = (DiscoverResult)Mockito.mock(DiscoverResult.class);
        Mockito.when((Object)this.mockDiscoverResult.getIndexableObjects()).thenReturn(Collections.singletonList(this.mockIndexablePoolTask));
        Mockito.when((Object)this.mockDiscoverResult.getTotalSearchResults()).thenReturn((Object)2L);
        Mockito.when((Object)this.mockSearchService.search((Context)Mockito.eq((Object)this.mockContext), (DiscoverQuery)Mockito.any(DiscoverQuery.class))).thenReturn((Object)this.mockDiscoverResult);
        try (MockedStatic mockedStatic = Mockito.mockStatic(SearchUtils.class);){
            mockedStatic.when(SearchUtils::getSearchService).thenReturn((Object)this.mockSearchService);
            DiscoverResultItemIterator iterator = new DiscoverResultItemIterator(this.mockContext, this.mockDiscoverQuery);
            iterator.next();
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)this.mockItem, (Object)iterator.next());
        }
    }

    @Test
    public void testNextWithIndexableClaimedTask() throws SearchServiceException {
        this.mockDiscoverResult = (DiscoverResult)Mockito.mock(DiscoverResult.class);
        Mockito.when((Object)this.mockDiscoverResult.getIndexableObjects()).thenReturn(Collections.singletonList(this.mockIndexableClaimedTask));
        Mockito.when((Object)this.mockDiscoverResult.getTotalSearchResults()).thenReturn((Object)2L);
        Mockito.when((Object)this.mockSearchService.search((Context)Mockito.eq((Object)this.mockContext), (DiscoverQuery)Mockito.any(DiscoverQuery.class))).thenReturn((Object)this.mockDiscoverResult);
        try (MockedStatic mockedStatic = Mockito.mockStatic(SearchUtils.class);){
            mockedStatic.when(SearchUtils::getSearchService).thenReturn((Object)this.mockSearchService);
            DiscoverResultItemIterator iterator = new DiscoverResultItemIterator(this.mockContext, this.mockDiscoverQuery);
            iterator.next();
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)this.mockItem, (Object)iterator.next());
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testNextWithInvalidObjectType() throws SearchServiceException {
        this.mockDiscoverResult = (DiscoverResult)Mockito.mock(DiscoverResult.class);
        IndexableObject invalidObject = (IndexableObject)Mockito.mock(IndexableObject.class);
        Mockito.when((Object)invalidObject.getIndexedObject()).thenReturn((Object)this.mockItem);
        Mockito.when((Object)invalidObject.getType()).thenReturn((Object)"InvalidObjectType");
        Mockito.when((Object)this.mockDiscoverResult.getIndexableObjects()).thenReturn(Collections.singletonList(invalidObject));
        Mockito.when((Object)this.mockSearchService.search((Context)Mockito.eq((Object)this.mockContext), (DiscoverQuery)Mockito.any(DiscoverQuery.class))).thenReturn((Object)this.mockDiscoverResult);
        try (MockedStatic mockedStatic = Mockito.mockStatic(SearchUtils.class);){
            mockedStatic.when(SearchUtils::getSearchService).thenReturn((Object)this.mockSearchService);
            DiscoverResultItemIterator iterator = new DiscoverResultItemIterator(this.mockContext, this.mockDiscoverQuery);
            iterator.next();
        }
    }
}

