/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamService;
import org.dspace.discovery.FullTextContentStreams;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FullTextContentStreamsTest {
    private static final String HANDLE = "1234567/123";
    private static final String CONTENT_TYPE = "text/plain";
    @InjectMocks
    private FullTextContentStreams streams;
    @Mock
    private BitstreamService bitstreamService;
    @Mock
    private Item item;
    @Mock
    private Bundle originalBundle;
    @Mock
    private Bundle textBundle;
    @Mock
    private Bitstream textBitstream1;
    @Mock
    private Bitstream textBitstream2;
    @Mock
    private Bitstream textBitstream3;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.item.getHandle()).thenReturn((Object)HANDLE);
        Mockito.when((Object)this.originalBundle.getName()).thenReturn((Object)"ORIGINAL");
        Mockito.when((Object)this.textBundle.getName()).thenReturn((Object)"TEXT");
        Mockito.when((Object)this.textBitstream1.getName()).thenReturn((Object)"Full Text 1");
        Mockito.when((Object)this.textBitstream2.getName()).thenReturn((Object)"Full Text 2");
        Mockito.when((Object)this.textBitstream3.getName()).thenReturn((Object)"Full Text 3");
        Mockito.when((Object)this.textBitstream1.getSizeBytes()).thenReturn((Object)1L);
        Mockito.when((Object)this.textBitstream2.getSizeBytes()).thenReturn((Object)2L);
        Mockito.when((Object)this.textBitstream3.getSizeBytes()).thenReturn((Object)3L);
        Mockito.when((Object)this.bitstreamService.retrieve(null, this.textBitstream1)).thenReturn((Object)new ByteArrayInputStream("This is text 1".getBytes(StandardCharsets.UTF_8)));
        Mockito.when((Object)this.bitstreamService.retrieve(null, this.textBitstream2)).thenReturn((Object)new ByteArrayInputStream("This is text 2".getBytes(StandardCharsets.UTF_8)));
        Mockito.when((Object)this.bitstreamService.retrieve(null, this.textBitstream3)).thenReturn((Object)new ByteArrayInputStream("This is text 3".getBytes(StandardCharsets.UTF_8)));
        this.streams.bitstreamService = this.bitstreamService;
    }

    @Test
    public void testItemWithNoBundles() throws Exception {
        Mockito.when((Object)this.item.getBundles()).thenReturn(null);
        this.streams.init(this.item);
        Assert.assertEquals((String)"Source info should give you the handle", (Object)HANDLE, (Object)this.streams.getSourceInfo());
        Assert.assertEquals((String)"Content type should be plain text", (Object)CONTENT_TYPE, (Object)this.streams.getContentType());
        Assert.assertEquals((String)"The name should be empty", (Object)"", (Object)this.streams.getName());
        Assert.assertEquals((String)"The size of the streams should be zero", (Object)0L, (Object)this.streams.getSize());
        Assert.assertTrue((String)"Content stream should be empty", (boolean)this.streams.isEmpty());
        InputStream inputStream = this.streams.getStream();
        Assert.assertNotNull((Object)inputStream);
        Assert.assertEquals((String)"Input stream should be empty", (long)-1L, (long)inputStream.read());
    }

    @Test
    public void testItemWithOnlyOriginalBundle() throws Exception {
        Mockito.when((Object)this.item.getBundles()).thenReturn(Arrays.asList(this.originalBundle));
        this.streams.init(this.item);
        Assert.assertEquals((String)"Source info should give you the handle", (Object)HANDLE, (Object)this.streams.getSourceInfo());
        Assert.assertEquals((String)"Content type should be plain text", (Object)CONTENT_TYPE, (Object)this.streams.getContentType());
        Assert.assertEquals((String)"The name should be empty", (Object)"", (Object)this.streams.getName());
        Assert.assertEquals((String)"The size of the streams should be zero", (Object)0L, (Object)this.streams.getSize());
        Assert.assertTrue((String)"Content stream should be empty", (boolean)this.streams.isEmpty());
        InputStream inputStream = this.streams.getStream();
        Assert.assertNotNull((Object)inputStream);
        Assert.assertEquals((String)"Input stream should be empty", (long)-1L, (long)inputStream.read());
    }

    @Test
    public void testItemWithEmptyTextBundle() throws Exception {
        Mockito.when((Object)this.item.getBundles()).thenReturn(Arrays.asList(this.originalBundle, this.textBundle));
        Mockito.when((Object)this.textBundle.getBitstreams()).thenReturn(null);
        this.streams.init(this.item);
        Assert.assertEquals((String)"Source info should give you the handle", (Object)HANDLE, (Object)this.streams.getSourceInfo());
        Assert.assertEquals((String)"Content type should be plain text", (Object)CONTENT_TYPE, (Object)this.streams.getContentType());
        Assert.assertEquals((String)"The name should be empty", (Object)"", (Object)this.streams.getName());
        Assert.assertEquals((String)"The size of the streams should be zero", (Object)0L, (Object)this.streams.getSize());
        Assert.assertTrue((String)"Content stream should be empty", (boolean)this.streams.isEmpty());
        InputStream inputStream = this.streams.getStream();
        Assert.assertNotNull((Object)inputStream);
        Assert.assertEquals((String)"Input stream should be empty", (long)-1L, (long)inputStream.read());
    }

    @Test
    public void testItemWithOnlyOneTextBitstream() throws Exception {
        Mockito.when((Object)this.item.getBundles()).thenReturn(Arrays.asList(this.originalBundle, this.textBundle));
        Mockito.when((Object)this.textBundle.getBitstreams()).thenReturn(Arrays.asList(this.textBitstream1));
        this.streams.init(this.item);
        Assert.assertEquals((String)"Source info should give you the handle", (Object)HANDLE, (Object)this.streams.getSourceInfo());
        Assert.assertEquals((String)"Content type should be plain text", (Object)CONTENT_TYPE, (Object)this.streams.getContentType());
        Assert.assertEquals((String)"The name should match the name of the bitstream", (Object)"Full Text 1", (Object)this.streams.getName());
        Assert.assertEquals((String)"The size of the streams should match the size of bitstream 1", (Object)1L, (Object)this.streams.getSize());
        Assert.assertFalse((String)"Content stream should not be empty", (boolean)this.streams.isEmpty());
        InputStream inputStream = this.streams.getStream();
        Assert.assertNotNull((Object)inputStream);
        Assert.assertEquals((String)"The data in the input stream should match the text of the bitstream", (Object)"\nThis is text 1", (Object)IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void testItemWithMultipleTextBitstreams() throws Exception {
        Mockito.when((Object)this.item.getBundles()).thenReturn(Arrays.asList(this.originalBundle, this.textBundle));
        Mockito.when((Object)this.textBundle.getBitstreams()).thenReturn(Arrays.asList(this.textBitstream1, this.textBitstream2, this.textBitstream3));
        this.streams.init(this.item);
        Assert.assertEquals((String)"Source info should give you the handle", (Object)HANDLE, (Object)this.streams.getSourceInfo());
        Assert.assertEquals((String)"Content type should be plain text", (Object)CONTENT_TYPE, (Object)this.streams.getContentType());
        Assert.assertEquals((String)"The name should match the concatenation of the names of the bitstreams", (Object)"Full Text 1;Full Text 2;Full Text 3", (Object)this.streams.getName());
        Assert.assertEquals((String)"The size of the streams should be the sum of the bitstream sizes", (Object)6L, (Object)this.streams.getSize());
        Assert.assertFalse((String)"Content stream should not be empty", (boolean)this.streams.isEmpty());
        InputStream inputStream = this.streams.getStream();
        Assert.assertNotNull((Object)inputStream);
        Assert.assertEquals((String)"The data in the input stream should match 'This is text 1'", (Object)"\nThis is text 1\nThis is text 2\nThis is text 3", (Object)IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void testBitstreamThrowingExceptionShouldNotStopIndexing() throws Exception {
        Mockito.when((Object)this.item.getBundles()).thenReturn(Arrays.asList(this.originalBundle, this.textBundle));
        Mockito.when((Object)this.textBundle.getBitstreams()).thenReturn(Arrays.asList(this.textBitstream1, this.textBitstream2, this.textBitstream3));
        Mockito.when((Object)this.bitstreamService.retrieve(null, this.textBitstream2)).thenThrow(new Throwable[]{new IOException("NOTFOUND")});
        this.streams.init(this.item);
        Assert.assertEquals((String)"Source info should give you the handle", (Object)HANDLE, (Object)this.streams.getSourceInfo());
        Assert.assertEquals((String)"Content type should be plain text", (Object)CONTENT_TYPE, (Object)this.streams.getContentType());
        Assert.assertEquals((String)"The name should match the concatenation of the names of the bitstreams", (Object)"Full Text 1;Full Text 2;Full Text 3", (Object)this.streams.getName());
        Assert.assertEquals((String)"The size of the streams should be the sum of the bitstream sizes", (Object)6L, (Object)this.streams.getSize());
        Assert.assertFalse((String)"Content stream should not be empty", (boolean)this.streams.isEmpty());
        InputStream inputStream = this.streams.getStream();
        Assert.assertNotNull((Object)inputStream);
        String content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        Assert.assertTrue((String)"The data should contain data of the first bitstream that is not corrupt", (boolean)content.contains("This is text 1"));
        Assert.assertFalse((String)"The data should NOT contain data of the second bitstream that is corrupt", (boolean)content.contains("This is text 2"));
        Assert.assertTrue((String)"The data should contain data of the third bitstream that is not corrupt", (boolean)content.contains("This is text 3"));
        Assert.assertTrue((String)"The data should contain data on the exception that occurred", (boolean)content.contains("java.io.IOException"));
        Assert.assertTrue((String)"The data should contain data on the exception that occurred", (boolean)content.contains("NOTFOUND"));
    }
}

