/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.disseminate;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.dspace.AbstractDSpaceTest;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.disseminate.CoverPageService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CoverPageServiceTest
extends AbstractDSpaceTest {
    @Mock
    Item item;
    List<MetadataValue> itemMetaData = new ArrayList<MetadataValue>();
    Set<String> metaDataKeys = new HashSet<String>();
    CoverPageService sut;

    @Before
    public void setUp() throws Exception {
        ((Item)Mockito.doReturn(this.itemMetaData).when((Object)this.item)).getMetadata();
        this.sut = new CoverPageService("dspace_coverpage", null);
    }

    @Test
    public void canRenderCoverPage() throws Exception {
        this.givenMetadataValues("dc_title", "My title");
        try (PDDocument coverPage = this.sut.renderCoverDocument(this.item);){
            MatcherAssert.assertThat((Object)coverPage.getNumberOfPages(), (Matcher)Matchers.equalTo((Object)1));
            String text = new PDFTextStripper().getText(coverPage);
            MatcherAssert.assertThat((Object)text, (Matcher)CoreMatchers.containsString((String)"My title"));
        }
    }

    @Test
    public void pageWithSubtitle() throws Exception {
        this.givenMetadataValues("dc_title", "My title");
        this.givenMetadataValues("dc_title_alternative", "subtitle");
        try (PDDocument coverPage = this.sut.renderCoverDocument(this.item);){
            MatcherAssert.assertThat((Object)coverPage.getNumberOfPages(), (Matcher)Matchers.equalTo((Object)1));
            String text = new PDFTextStripper().getText(coverPage);
            MatcherAssert.assertThat((Object)text, (Matcher)CoreMatchers.containsString((String)"My title: subtitle"));
        }
    }

    @Test
    public void multipleAuthors() throws Exception {
        this.givenMetadataValues("dc_title", "My title", "dc_contributor_author", "My author 1", "dc_contributor_author", "My author 2", "dc_creator", "My author 3");
        try (PDDocument coverPage = this.sut.renderCoverDocument(this.item);){
            MatcherAssert.assertThat((Object)coverPage.getNumberOfPages(), (Matcher)Matchers.equalTo((Object)1));
            String text = new PDFTextStripper().getText(coverPage);
            MatcherAssert.assertThat((Object)text, (Matcher)CoreMatchers.containsString((String)"My author 1; My author 2; My author 3"));
        }
    }

    @Test
    public void multipleEditors() throws Exception {
        this.givenMetadataValues("dc_title", "My title", "dc_contributor_author", "My author 1", "dc_contributor_editor", "My editor 1", "dc_contributor_editor", "My editor 2");
        try (PDDocument coverPage = this.sut.renderCoverDocument(this.item);){
            MatcherAssert.assertThat((Object)coverPage.getNumberOfPages(), (Matcher)Matchers.equalTo((Object)1));
            String text = new PDFTextStripper().getText(coverPage);
            MatcherAssert.assertThat((Object)text, (Matcher)CoreMatchers.containsString((String)"My editor 1; My editor 2"));
        }
    }

    private void givenMetadataValues(String ... entries) {
        if (entries.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < entries.length; i += 2) {
            int place = 0;
            if (this.metaDataKeys.contains(entries[i])) {
                place = 1;
            }
            this.itemMetaData.add(this.aMetadataValue(entries[i], entries[i + 1], place));
            this.metaDataKeys.add(entries[i]);
        }
    }

    private MetadataValue aMetadataValue(String key, String value, int place) {
        MetadataValue mock = (MetadataValue)Mockito.mock(MetadataValue.class);
        MetadataField f = (MetadataField)Mockito.mock(MetadataField.class);
        ((MetadataValue)Mockito.doReturn((Object)f).when((Object)mock)).getMetadataField();
        ((MetadataField)Mockito.doReturn((Object)key).when((Object)f)).toString();
        ((MetadataValue)Mockito.doReturn((Object)value).when((Object)mock)).getValue();
        ((MetadataValue)Mockito.doReturn((Object)place).when((Object)mock)).getPlace();
        return mock;
    }
}

