/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.MetadataFieldBuilder;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataField;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.RegistrationData;
import org.dspace.eperson.RegistrationTypeEnum;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.AccountService;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.RegistrationDataService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AccountServiceImplIT
extends AbstractIntegrationTestWithDatabase {
    public static final String ORCID_NETID = "vins01";
    public static final String ORCID_EMAIL = "vins-01@fake.mail";
    public static final String CUSTOM_METADATA_VALUE = "vins01-customID";
    AccountService accountService = EPersonServiceFactory.getInstance().getAccountService();
    EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    RegistrationDataService registrationDataService = EPersonServiceFactory.getInstance().getRegistrationDataService();
    EPerson tokenPerson;
    RegistrationData orcidToken;
    MetadataField metadataField;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.tokenPerson = EPersonBuilder.createEPerson(this.context).withNameInMetadata("Vincenzo", "Mecca").withEmail(null).withNetId(null).withCanLogin(true).build();
        this.metadataField = MetadataFieldBuilder.createMetadataField(this.context, "identifier", "custom", null).build();
        this.orcidToken = this.registrationDataService.create(this.context, ORCID_NETID, RegistrationTypeEnum.ORCID);
        this.orcidToken.setEmail(ORCID_EMAIL);
        this.registrationDataService.addMetadata(this.context, this.orcidToken, this.metadataField, CUSTOM_METADATA_VALUE);
        this.registrationDataService.update(this.context, (Object)this.orcidToken);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testMergedORCIDRegistration() throws SQLException, AuthorizeException {
        this.context.setCurrentUser(this.tokenPerson);
        EPerson updatedEperson = this.accountService.mergeRegistration(this.context, this.tokenPerson.getID(), this.orcidToken.getToken(), List.of());
        MatcherAssert.assertThat((Object)updatedEperson, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)updatedEperson.getEmail(), (Matcher)CoreMatchers.is((Object)ORCID_EMAIL));
        MatcherAssert.assertThat((Object)updatedEperson.getNetid(), (Matcher)CoreMatchers.is((Object)ORCID_NETID));
        String customMetadataFound = this.ePersonService.getMetadataFirstValue((DSpaceObject)updatedEperson, this.metadataField.getMetadataSchema().getName(), this.metadataField.getElement(), this.metadataField.getQualifier(), "*");
        MatcherAssert.assertThat((Object)customMetadataFound, (Matcher)CoreMatchers.is((Object)CUSTOM_METADATA_VALUE));
        MatcherAssert.assertThat((Object)this.registrationDataService.findByToken(this.context, this.orcidToken.getToken()), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testMergedORCIDRegistrationWithOverwrittenMetadata() throws SQLException, AuthorizeException {
        this.context.setCurrentUser(this.tokenPerson);
        this.registrationDataService.addMetadata(this.context, this.orcidToken, "eperson", "firstname", null, "Vins");
        this.registrationDataService.addMetadata(this.context, this.orcidToken, "eperson", "lastname", null, "4Science");
        this.registrationDataService.update(this.context, (Object)this.orcidToken);
        EPerson updatedEperson = this.accountService.mergeRegistration(this.context, this.tokenPerson.getID(), this.orcidToken.getToken(), List.of("eperson.firstname", "eperson.lastname"));
        MatcherAssert.assertThat((Object)updatedEperson, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)updatedEperson.getEmail(), (Matcher)CoreMatchers.is((Object)ORCID_EMAIL));
        MatcherAssert.assertThat((Object)updatedEperson.getNetid(), (Matcher)CoreMatchers.is((Object)ORCID_NETID));
        MatcherAssert.assertThat((Object)updatedEperson.getFirstName(), (Matcher)CoreMatchers.is((Object)"Vins"));
        MatcherAssert.assertThat((Object)updatedEperson.getLastName(), (Matcher)CoreMatchers.is((Object)"4Science"));
        String customMetadataFound = this.ePersonService.getMetadataFirstValue((DSpaceObject)updatedEperson, this.metadataField.getMetadataSchema().getName(), this.metadataField.getElement(), this.metadataField.getQualifier(), "*");
        MatcherAssert.assertThat((Object)customMetadataFound, (Matcher)CoreMatchers.is((Object)CUSTOM_METADATA_VALUE));
        MatcherAssert.assertThat((Object)this.registrationDataService.findByToken(this.context, this.orcidToken.getToken()), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testCannotMergedORCIDRegistrationWithDifferentLoggedEperson() {
        this.context.setCurrentUser(this.admin);
        Assert.assertThrows(AuthorizeException.class, () -> this.accountService.mergeRegistration(this.context, this.tokenPerson.getID(), this.orcidToken.getToken(), List.of()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateUserWithRegistration() throws SQLException, AuthorizeException, IOException {
        this.context.setCurrentUser(null);
        this.context.turnOffAuthorisationSystem();
        RegistrationData orcidRegistration = this.registrationDataService.create(this.context, ORCID_NETID, RegistrationTypeEnum.VALIDATION_ORCID);
        this.registrationDataService.addMetadata(this.context, orcidRegistration, "eperson", "firstname", null, "Vincenzo");
        this.registrationDataService.addMetadata(this.context, orcidRegistration, "eperson", "lastname", null, "Mecca");
        orcidRegistration.setEmail(ORCID_EMAIL);
        this.registrationDataService.update(this.context, (Object)orcidRegistration);
        this.context.commit();
        this.context.restoreAuthSystemState();
        EPerson createdEPerson = null;
        try {
            createdEPerson = this.accountService.mergeRegistration(this.context, null, orcidRegistration.getToken(), List.of());
            MatcherAssert.assertThat((Object)createdEPerson, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)createdEPerson.getFirstName(), (Matcher)CoreMatchers.is((Object)"Vincenzo"));
            MatcherAssert.assertThat((Object)createdEPerson.getLastName(), (Matcher)CoreMatchers.is((Object)"Mecca"));
            MatcherAssert.assertThat((Object)createdEPerson.getEmail(), (Matcher)CoreMatchers.is((Object)ORCID_EMAIL));
            MatcherAssert.assertThat((Object)createdEPerson.getNetid(), (Matcher)CoreMatchers.is((Object)ORCID_NETID));
            MatcherAssert.assertThat((Object)this.registrationDataService.findByToken(this.context, orcidRegistration.getToken()), (Matcher)CoreMatchers.nullValue());
        }
        finally {
            this.context.turnOffAuthorisationSystem();
            this.ePersonService.delete(this.context, (DSpaceObject)((EPerson)this.context.reloadEntity((ReloadableEntity)createdEPerson)));
            RegistrationData found = (RegistrationData)this.context.reloadEntity((ReloadableEntity)orcidRegistration);
            if (found != null) {
                this.registrationDataService.delete(this.context, (Object)found);
            }
            this.context.restoreAuthSystemState();
        }
    }

    @Test
    public void testInvalidMergeWithoutValidToken() throws SQLException, AuthorizeException {
        RegistrationData anyToken = this.registrationDataService.create(this.context, ORCID_NETID, RegistrationTypeEnum.REGISTER);
        try {
            Assert.assertThrows(AuthorizeException.class, () -> this.accountService.mergeRegistration(this.context, null, anyToken.getToken(), List.of()));
            anyToken.setRegistrationType(RegistrationTypeEnum.FORGOT);
            this.registrationDataService.update(this.context, (Object)anyToken);
            Assert.assertThrows(AuthorizeException.class, () -> this.accountService.mergeRegistration(this.context, null, anyToken.getToken(), List.of()));
            anyToken.setRegistrationType(RegistrationTypeEnum.CHANGE_PASSWORD);
            this.registrationDataService.update(this.context, (Object)anyToken);
            Assert.assertThrows(AuthorizeException.class, () -> this.accountService.mergeRegistration(this.context, null, anyToken.getToken(), List.of()));
            anyToken.setRegistrationType(RegistrationTypeEnum.INVITATION);
            this.registrationDataService.update(this.context, (Object)anyToken);
            Assert.assertThrows(AuthorizeException.class, () -> this.accountService.mergeRegistration(this.context, null, anyToken.getToken(), List.of()));
        }
        finally {
            this.registrationDataService.delete(this.context, (Object)((RegistrationData)this.context.reloadEntity((ReloadableEntity)anyToken)));
        }
    }
}

