/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import jakarta.mail.MessagingException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.EPersonDeletionException;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.workflow.WorkflowException;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowItemService;
import org.dspace.workflow.WorkflowService;
import org.dspace.workflow.factory.WorkflowServiceFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EPersonTest
extends AbstractUnitTest {
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected WorkflowItemService workflowItemService = WorkflowServiceFactory.getInstance().getWorkflowItemService();
    protected WorkflowService workflowService = WorkflowServiceFactory.getInstance().getWorkflowService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    private Community community = null;
    private org.dspace.content.Collection collection = null;
    private Item item = null;
    private static final String EMAIL = "test@example.com";
    private static final String FIRSTNAME = "Kevin";
    private static final String LASTNAME = "Van de Velde";
    private static final String NETID = "1985";
    private static final String PASSWORD = "test";
    private static final Logger log = LogManager.getLogger(EPersonTest.class);

    @Override
    @Before
    public void init() {
        super.init();
        this.context.turnOffAuthorisationSystem();
        try {
            EPerson eperson = this.ePersonService.create(this.context);
            eperson.setEmail(EMAIL);
            eperson.setFirstName(this.context, FIRSTNAME);
            eperson.setLastName(this.context, LASTNAME);
            eperson.setNetid(NETID);
            eperson.setPassword(PASSWORD);
            this.ePersonService.update(this.context, (DSpaceObject)eperson);
            this.community = this.communityService.create(null, this.context);
            this.collection = this.collectionService.create(this.context, this.community);
        }
        catch (SQLException | AuthorizeException ex) {
            log.error("Error in init", ex);
            Assert.fail((String)("Error in init: " + ex.getMessage()));
        }
        finally {
            this.context.restoreAuthSystemState();
        }
    }

    @Override
    public void destroy() {
        this.context.turnOffAuthorisationSystem();
        try {
            EPerson testPerson = this.ePersonService.findByEmail(this.context, EMAIL);
            if (testPerson != null) {
                this.ePersonService.delete(this.context, (DSpaceObject)testPerson);
            }
        }
        catch (IOException | SQLException | AuthorizeException ex) {
            log.error("Error in destroy", ex);
            Assert.fail((String)("Error in destroy: " + ex.getMessage()));
        }
        if (this.item != null) {
            try {
                this.item = (Item)this.itemService.find(this.context, this.item.getID());
                this.itemService.delete(this.context, (DSpaceObject)this.item);
            }
            catch (IOException | SQLException | AuthorizeException ex) {
                log.error("Error in destroy", ex);
                Assert.fail((String)("Error in destroy: " + ex.getMessage()));
            }
        }
        if (this.collection != null) {
            try {
                this.collection = (org.dspace.content.Collection)this.collectionService.find(this.context, this.collection.getID());
                this.collectionService.delete(this.context, (DSpaceObject)this.collection);
            }
            catch (IOException | SQLException | AuthorizeException ex) {
                log.error("Error in destroy", ex);
                Assert.fail((String)("Error in destroy: " + ex.getMessage()));
            }
        }
        if (this.community != null) {
            try {
                this.community = (Community)this.communityService.find(this.context, this.community.getID());
                this.communityService.delete(this.context, (DSpaceObject)this.community);
            }
            catch (IOException | SQLException | AuthorizeException ex) {
                log.error("Error in destroy", ex);
                Assert.fail((String)("Error in destroy: " + ex.getMessage()));
            }
        }
        this.context.restoreAuthSystemState();
        this.item = null;
        this.collection = null;
        this.community = null;
        super.destroy();
    }

    @Test
    public void testPreferences() throws Exception {
        String cookies = "{\"token_item\":true,\"impersonation\":true,\"redirect\":true,\"language\":true,\"klaro\":true,\"google-analytics\":false}";
        this.ePersonService.addMetadata(this.context, (DSpaceObject)this.eperson, "dspace", "agreements", "cookies", null, cookies);
        this.ePersonService.addMetadata(this.context, (DSpaceObject)this.eperson, "dspace", "agreements", "end-user", null, "true");
        this.ePersonService.update(this.context, (DSpaceObject)this.eperson);
        Assert.assertEquals((Object)cookies, (Object)this.ePersonService.getMetadataFirstValue((DSpaceObject)this.eperson, "dspace", "agreements", "cookies", null));
        Assert.assertEquals((Object)"true", (Object)this.ePersonService.getMetadataFirstValue((DSpaceObject)this.eperson, "dspace", "agreements", "end-user", null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSearchAndCountByNameEmail() throws SQLException, AuthorizeException, IOException {
        ArrayList<EPerson> allEPeopleAdded = new ArrayList<EPerson>();
        Group testGroup = this.createGroup("TestingGroup");
        try {
            EPerson eperson1 = this.createEPersonAndAddToGroup("eperson1@example.com", "Jane", "Doe", testGroup);
            EPerson eperson2 = this.createEPerson("eperson2@example.com", "John", "Doe");
            EPerson eperson3 = this.createEPersonAndAddToGroup("eperson3@example.com", "John", "Smith", testGroup);
            EPerson eperson4 = this.createEPerson("eperson4@example.com", "Doe", "Smith");
            allEPeopleAdded.addAll(Arrays.asList(eperson1, eperson2, eperson3, eperson4));
            List<EPerson> allJohns = Arrays.asList(eperson2, eperson3);
            List searchJohnResults = this.ePersonService.search(this.context, "John", -1, -1);
            Assert.assertTrue((boolean)searchJohnResults.containsAll(allJohns));
            Assert.assertEquals((long)searchJohnResults.size(), (long)this.ePersonService.searchResultCount(this.context, "John"));
            List<EPerson> allDoes = Arrays.asList(eperson1, eperson2, eperson4);
            List searchDoeResults = this.ePersonService.search(this.context, "Doe", -1, -1);
            Assert.assertTrue((boolean)searchDoeResults.containsAll(allDoes));
            Assert.assertEquals((long)searchDoeResults.size(), (long)this.ePersonService.searchResultCount(this.context, "Doe"));
            List<EPerson> allSmiths = Arrays.asList(eperson3, eperson4);
            List searchSmithResults = this.ePersonService.search(this.context, "Smith", -1, -1);
            Assert.assertTrue((boolean)searchSmithResults.containsAll(allSmiths));
            Assert.assertEquals((long)searchSmithResults.size(), (long)this.ePersonService.searchResultCount(this.context, "Smith"));
            List searchEmailResults = this.ePersonService.search(this.context, "example.com", -1, -1);
            Assert.assertTrue((boolean)searchEmailResults.containsAll(allEPeopleAdded));
            Assert.assertEquals((long)searchEmailResults.size(), (long)this.ePersonService.searchResultCount(this.context, "example.com"));
            List exactEmailResults = this.ePersonService.search(this.context, "eperson1@example.com", -1, -1);
            Assert.assertTrue((boolean)exactEmailResults.contains(eperson1));
            Assert.assertEquals((long)exactEmailResults.size(), (long)this.ePersonService.searchResultCount(this.context, "eperson1@example.com"));
            List uuidResults = this.ePersonService.search(this.context, eperson4.getID().toString(), -1, -1);
            Assert.assertTrue((boolean)uuidResults.contains(eperson4));
            Assert.assertEquals((long)1L, (long)uuidResults.size());
            Assert.assertEquals((long)uuidResults.size(), (long)this.ePersonService.searchResultCount(this.context, eperson4.getID().toString()));
        }
        finally {
            this.context.turnOffAuthorisationSystem();
            this.groupService.delete(this.context, (DSpaceObject)testGroup);
            for (EPerson ePerson : allEPeopleAdded) {
                this.ePersonService.delete(this.context, (DSpaceObject)ePerson);
            }
            this.context.restoreAuthSystemState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSearchAndCountByNameEmailNonMembers() throws SQLException, AuthorizeException, IOException {
        ArrayList<EPerson> allEPeopleAdded = new ArrayList<EPerson>();
        Group testGroup1 = this.createGroup("TestingGroup1");
        Group testGroup2 = this.createGroup("TestingGroup2");
        Group testGroup3 = this.createGroup("TestingGroup3");
        try {
            EPerson eperson1 = this.createEPersonAndAddToGroup("eperson1@example.com", "Jane", "Doe", testGroup1);
            EPerson eperson2 = this.createEPersonAndAddToGroup("eperson2@example.com", "John", "Smith", testGroup1);
            EPerson eperson3 = this.createEPersonAndAddToGroup("eperson3@example.com", "John", "Doe", testGroup2);
            this.context.turnOffAuthorisationSystem();
            this.groupService.addMember(this.context, testGroup2, eperson2);
            this.groupService.update(this.context, (DSpaceObject)testGroup2);
            this.ePersonService.update(this.context, (DSpaceObject)eperson2);
            this.context.restoreAuthSystemState();
            EPerson eperson4 = this.createEPerson("eperson4@example.com", "John", "Anthony");
            EPerson eperson5 = this.createEPerson("eperson5@example.org", "Smith", "Doe");
            allEPeopleAdded.addAll(Arrays.asList(eperson1, eperson2, eperson3, eperson4, eperson5));
            List<EPerson> allDoes = Arrays.asList(eperson1, eperson3, eperson5);
            List searchDoeResults = this.ePersonService.searchNonMembers(this.context, "Doe", testGroup3, -1, -1);
            Assert.assertTrue((boolean)searchDoeResults.containsAll(allDoes));
            Assert.assertEquals((long)searchDoeResults.size(), (long)this.ePersonService.searchNonMembersCount(this.context, "Doe", testGroup3));
            List<EPerson> allNonMemberDoes = Arrays.asList(eperson1, eperson5);
            List searchNonMemberDoeResults = this.ePersonService.searchNonMembers(this.context, "Doe", testGroup2, -1, -1);
            Assert.assertTrue((boolean)searchNonMemberDoeResults.containsAll(allNonMemberDoes));
            Assert.assertFalse((boolean)searchNonMemberDoeResults.contains(eperson3));
            Assert.assertEquals((long)searchNonMemberDoeResults.size(), (long)this.ePersonService.searchNonMembersCount(this.context, "Doe", testGroup2));
            allNonMemberDoes = Arrays.asList(eperson3, eperson5);
            searchNonMemberDoeResults = this.ePersonService.searchNonMembers(this.context, "Doe", testGroup1, -1, -1);
            Assert.assertTrue((boolean)searchNonMemberDoeResults.containsAll(allNonMemberDoes));
            Assert.assertFalse((boolean)searchNonMemberDoeResults.contains(eperson1));
            Assert.assertEquals((long)searchNonMemberDoeResults.size(), (long)this.ePersonService.searchNonMembersCount(this.context, "Doe", testGroup1));
            List<EPerson> allJohns = Arrays.asList(eperson2, eperson3, eperson4);
            List searchJohnResults = this.ePersonService.searchNonMembers(this.context, "John", testGroup3, -1, -1);
            Assert.assertTrue((boolean)searchJohnResults.containsAll(allJohns));
            Assert.assertEquals((long)searchJohnResults.size(), (long)this.ePersonService.searchNonMembersCount(this.context, "John", testGroup3));
            List<EPerson> allNonMemberJohns = Arrays.asList(eperson4);
            List searchNonMemberJohnResults = this.ePersonService.searchNonMembers(this.context, "John", testGroup2, -1, -1);
            Assert.assertTrue((boolean)searchNonMemberJohnResults.containsAll(allNonMemberJohns));
            Assert.assertFalse((boolean)searchNonMemberJohnResults.contains(eperson2));
            Assert.assertFalse((boolean)searchNonMemberJohnResults.contains(eperson3));
            Assert.assertEquals((long)searchNonMemberJohnResults.size(), (long)this.ePersonService.searchNonMembersCount(this.context, "John", testGroup2));
            List<EPerson> exampleNonMembers = Arrays.asList(eperson3, eperson4);
            List searchEmailResults = this.ePersonService.searchNonMembers(this.context, "example.com", testGroup1, -1, -1);
            Assert.assertTrue((boolean)searchEmailResults.containsAll(exampleNonMembers));
            Assert.assertFalse((boolean)searchEmailResults.contains(eperson1));
            Assert.assertFalse((boolean)searchEmailResults.contains(eperson2));
            Assert.assertEquals((long)searchEmailResults.size(), (long)this.ePersonService.searchNonMembersCount(this.context, "example.com", testGroup1));
            List exactEmailResults = this.ePersonService.searchNonMembers(this.context, "eperson1@example.com", testGroup2, -1, -1);
            Assert.assertTrue((boolean)exactEmailResults.contains(eperson1));
            Assert.assertEquals((long)exactEmailResults.size(), (long)this.ePersonService.searchNonMembersCount(this.context, "eperson1@example.com", testGroup2));
            exactEmailResults = this.ePersonService.searchNonMembers(this.context, "eperson1@example.com", testGroup1, -1, -1);
            Assert.assertFalse((boolean)exactEmailResults.contains(eperson1));
            Assert.assertEquals((long)exactEmailResults.size(), (long)this.ePersonService.searchNonMembersCount(this.context, "eperson1@example.com", testGroup1));
            List uuidResults = this.ePersonService.searchNonMembers(this.context, eperson3.getID().toString(), testGroup1, -1, -1);
            Assert.assertTrue((boolean)uuidResults.contains(eperson3));
            Assert.assertEquals((long)1L, (long)uuidResults.size());
            Assert.assertEquals((long)uuidResults.size(), (long)this.ePersonService.searchNonMembersCount(this.context, eperson3.getID().toString(), testGroup1));
            uuidResults = this.ePersonService.searchNonMembers(this.context, eperson3.getID().toString(), testGroup2, -1, -1);
            Assert.assertFalse((boolean)uuidResults.contains(eperson3));
            Assert.assertEquals((long)0L, (long)uuidResults.size());
            Assert.assertEquals((long)uuidResults.size(), (long)this.ePersonService.searchNonMembersCount(this.context, eperson3.getID().toString(), testGroup2));
        }
        finally {
            this.context.turnOffAuthorisationSystem();
            this.groupService.delete(this.context, (DSpaceObject)testGroup1);
            this.groupService.delete(this.context, (DSpaceObject)testGroup2);
            this.groupService.delete(this.context, (DSpaceObject)testGroup3);
            for (EPerson ePerson : allEPeopleAdded) {
                this.ePersonService.delete(this.context, (DSpaceObject)ePerson);
            }
            this.context.restoreAuthSystemState();
        }
    }

    @Test
    public void testCheckPassword() throws SQLException, DecoderException {
        EPerson eperson = this.ePersonService.findByEmail(this.context, EMAIL);
        this.ePersonService.checkPassword(this.context, eperson, PASSWORD);
    }

    @Test
    public void testGetType() throws SQLException {
        System.out.println("getType");
        int expResult = 7;
        int result = this.eperson.getType();
        Assert.assertEquals((String)"Should return Constants.EPERSON", (long)expResult, (long)result);
    }

    @Test
    public void testDeleteEPerson() throws SQLException, AuthorizeException {
        EPerson deleteEperson = this.ePersonService.findByEmail(this.context, EMAIL);
        this.context.turnOffAuthorisationSystem();
        try {
            this.ePersonService.delete(this.context, (DSpaceObject)deleteEperson);
        }
        catch (IOException | AuthorizeException ex) {
            log.error("Cannot delete EPersion, caught " + ex.getClass().getName() + ":", ex);
            Assert.fail((String)("Caught an Exception while deleting an EPerson. " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
        this.context.restoreAuthSystemState();
        this.context.commit();
        EPerson findDeletedEperson = this.ePersonService.findByEmail(this.context, EMAIL);
        Assert.assertNull((String)"EPerson has not been deleted correctly!", (Object)findDeletedEperson);
    }

    @Test
    public void testDeletionConstraintOfSubmitter() throws SQLException {
        EPerson ep = this.ePersonService.findByEmail(this.context, EMAIL);
        try {
            this.item = this.prepareItem(ep);
        }
        catch (IOException | SQLException | AuthorizeException ex) {
            log.error("Caught an Exception while initializing an Item. " + ex.getClass().getName() + ": ", ex);
            Assert.fail((String)("Caught an Exception while initializing an Item. " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
        this.context.turnOffAuthorisationSystem();
        List tableList = this.ePersonService.getDeleteConstraints(this.context, ep);
        for (String tableName : tableList) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)tableName, (CharSequence)"item")) continue;
            return;
        }
        Assert.fail((String)"It was not recognized that a EPerson is referenced in the item table.");
    }

    @Test
    public void testDeletionOfSubmitterWithAnItem() throws SQLException, AuthorizeException {
        EPerson ep = this.ePersonService.findByEmail(this.context, EMAIL);
        try {
            this.item = this.prepareItem(ep);
        }
        catch (IOException | SQLException | AuthorizeException ex) {
            log.error("Caught an Exception while initializing an Item. " + ex.getClass().getName() + ": ", ex);
            Assert.fail((String)("Caught an Exception while initializing an Item. " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
        Assert.assertNotNull((Object)this.item);
        this.context.turnOffAuthorisationSystem();
        try {
            this.ePersonService.delete(this.context, (DSpaceObject)ep);
        }
        catch (IOException | SQLException | AuthorizeException ex) {
            if (ex.getCause() instanceof EPersonDeletionException) {
                Assert.fail((String)("Caught an EPersonDeletionException while trying to cascading delete an EPerson: " + ex.getMessage()));
            }
            log.error("Caught an Exception while deleting an EPerson. " + ex.getClass().getName() + ": ", ex);
            Assert.fail((String)("Caught an Exception while deleting an EPerson. " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
        this.item = (Item)this.itemService.find(this.context, this.item.getID());
        Assert.assertNotNull((String)"Could not load item after cascading deletion of the submitter.", (Object)this.item);
        Assert.assertNull((String)"Cascading deletion of an EPerson did not set the submitter of an submitted item null.", (Object)this.item.getSubmitter());
    }

    @Test
    public void testCascadingDeletionOfUnsubmittedWorkspaceItem() throws SQLException, AuthorizeException, IOException {
        EPerson ep = this.ePersonService.findByEmail(this.context, EMAIL);
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem wsi = this.prepareWorkspaceItem(ep);
        Item item = wsi.getItem();
        this.itemService.addMetadata(this.context, (DSpaceObject)item, "dc", "title", null, "en", "Testdocument 1");
        this.itemService.update(this.context, (DSpaceObject)item);
        this.context.restoreAuthSystemState();
        this.context.commit();
        this.context.turnOffAuthorisationSystem();
        try {
            this.ePersonService.delete(this.context, (DSpaceObject)ep);
        }
        catch (IOException | SQLException | AuthorizeException ex) {
            if (ex.getCause() instanceof EPersonDeletionException) {
                Assert.fail((String)("Caught an EPersonDeletionException while trying to cascading delete an EPerson: " + ex.getMessage()));
            }
            log.error("Caught an Exception while deleting an EPerson. " + ex.getClass().getName() + ": ", ex);
            Assert.fail((String)("Caught an Exception while deleting an EPerson. " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
        this.context.restoreAuthSystemState();
        this.context.commit();
        try {
            WorkspaceItem restoredWsi = this.workspaceItemService.find(this.context, wsi.getID().intValue());
            Item restoredItem = (Item)this.itemService.find(this.context, item.getID());
            Assert.assertNull((String)"An unsubmited WorkspaceItem wasn't deleted while cascading deleting the submitter.", (Object)restoredWsi);
            Assert.assertNull((String)"An unsubmited Item wasn't deleted while cascading deleting the submitter.", (Object)restoredItem);
        }
        catch (SQLException ex) {
            log.error("SQLException while trying to load previously stored. " + ex);
        }
    }

    @Test
    public void testCascadingDeleteSubmitterPreservesWorkflowItems() throws SQLException, AuthorizeException, IOException, MessagingException, WorkflowException {
        EPerson ep = this.ePersonService.findByEmail(this.context, EMAIL);
        WorkspaceItem wsi = null;
        try {
            wsi = this.prepareWorkspaceItem(ep);
        }
        catch (IOException | SQLException | AuthorizeException ex) {
            log.error("Caught an Exception while initializing an WorkspaceItem. " + ex.getClass().getName() + ": ", ex);
            Assert.fail((String)("Caught an Exception while initializing an WorkspaceItem. " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
        Assert.assertNotNull((Object)wsi);
        this.context.turnOffAuthorisationSystem();
        Group wfGroup = this.collectionService.createWorkflowGroup(this.context, wsi.getCollection(), 1);
        this.collectionService.update(this.context, (DSpaceObject)wsi.getCollection());
        EPerson groupMember = this.ePersonService.create(this.context);
        groupMember.setEmail("testCascadingDeleteSubmitterPreservesWorkflowItems2@example.org");
        this.ePersonService.update(this.context, (DSpaceObject)groupMember);
        wfGroup.addMember(groupMember);
        this.groupService.update(this.context, (DSpaceObject)wfGroup);
        int wfiID = this.workflowService.startWithoutNotify(this.context, wsi).getID();
        this.context.restoreAuthSystemState();
        this.context.commit();
        this.context.turnOffAuthorisationSystem();
        Assert.assertNotNull((String)"Cannot find currently created WorkflowItem!", (Object)this.workflowItemService.find(this.context, wfiID));
        try {
            this.ePersonService.delete(this.context, (DSpaceObject)ep);
        }
        catch (IOException | SQLException | AuthorizeException ex) {
            if (ex.getCause() instanceof EPersonDeletionException) {
                Assert.fail((String)("Caught an EPersonDeletionException while trying to cascading delete an EPerson: " + ex.getMessage()));
            }
            log.error("Caught an Exception while deleting an EPerson. " + ex.getClass().getName() + ": ", ex);
            Assert.fail((String)("Caught an Exception while deleting an EPerson. " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
        this.context.restoreAuthSystemState();
        this.context.commit();
        this.context.turnOffAuthorisationSystem();
        WorkflowItem wfi = this.workflowItemService.find(this.context, wfiID);
        Assert.assertNotNull((String)"Could not load WorkflowItem after cascading deletion of the submitter.", (Object)wfi);
        Assert.assertNull((String)"Cascading deletion of an EPerson did not set the submitter of an submitted WorkflowItem null.", (Object)wfi.getSubmitter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void findAndCountByGroups() throws SQLException, AuthorizeException, IOException {
        Group group = this.createGroup("parentGroup");
        EPerson eperson1 = this.createEPersonAndAddToGroup("test1@example.com", group);
        EPerson eperson2 = this.createEPersonAndAddToGroup("test2@example.com", group);
        EPerson eperson3 = this.createEPersonAndAddToGroup("test3@example.com", group);
        this.groupService.update(this.context, (DSpaceObject)group);
        Group group2 = null;
        EPerson eperson4 = null;
        try {
            Assert.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)group.getMembers(), (Collection)this.ePersonService.findByGroups(this.context, Set.of(group), -1, -1)));
            Assert.assertEquals((long)group.getMembers().size(), (long)this.ePersonService.countByGroups(this.context, Set.of(group)));
            group2 = this.createGroup("anotherGroup");
            this.groupService.addMember(this.context, group2, eperson1);
            this.groupService.update(this.context, (DSpaceObject)group2);
            Assert.assertEquals((long)3L, (long)this.ePersonService.countByGroups(this.context, Set.of(group, group2)));
            eperson4 = this.createEPersonAndAddToGroup("test4@example.com", group2);
            Assert.assertEquals((long)4L, (long)this.ePersonService.countByGroups(this.context, Set.of(group, group2)));
        }
        catch (Throwable throwable) {
            this.context.turnOffAuthorisationSystem();
            this.groupService.delete(this.context, (DSpaceObject)group);
            if (group2 != null) {
                this.groupService.delete(this.context, group2);
            }
            this.ePersonService.delete(this.context, (DSpaceObject)eperson1);
            this.ePersonService.delete(this.context, (DSpaceObject)eperson2);
            this.ePersonService.delete(this.context, (DSpaceObject)eperson3);
            if (eperson4 != null) {
                this.ePersonService.delete(this.context, eperson4);
            }
            this.context.restoreAuthSystemState();
            throw throwable;
        }
        this.context.turnOffAuthorisationSystem();
        this.groupService.delete(this.context, (DSpaceObject)group);
        if (group2 != null) {
            this.groupService.delete(this.context, (DSpaceObject)group2);
        }
        this.ePersonService.delete(this.context, (DSpaceObject)eperson1);
        this.ePersonService.delete(this.context, (DSpaceObject)eperson2);
        this.ePersonService.delete(this.context, (DSpaceObject)eperson3);
        if (eperson4 != null) {
            this.ePersonService.delete(this.context, (DSpaceObject)eperson4);
        }
        this.context.restoreAuthSystemState();
    }

    private Item prepareItem(EPerson submitter) throws SQLException, AuthorizeException, IOException {
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem wsi = this.prepareWorkspaceItem(submitter);
        this.item = this.installItemService.installItem(this.context, (InProgressSubmission)wsi);
        this.context.restoreAuthSystemState();
        return this.item;
    }

    private WorkspaceItem prepareWorkspaceItem(EPerson submitter) throws SQLException, AuthorizeException, IOException {
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem wsi = this.workspaceItemService.create(this.context, this.collection, false);
        wsi.getItem().setSubmitter(submitter);
        this.workspaceItemService.update(this.context, (InProgressSubmission)wsi);
        this.context.restoreAuthSystemState();
        return wsi;
    }

    protected Group createGroup(String name) throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        Group group = this.groupService.create(this.context);
        group.setName(name);
        this.groupService.update(this.context, (DSpaceObject)group);
        this.context.restoreAuthSystemState();
        return group;
    }

    protected EPerson createEPersonAndAddToGroup(String email, Group group) throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = this.createEPerson(email);
        this.groupService.addMember(this.context, group, ePerson);
        this.groupService.update(this.context, (DSpaceObject)group);
        this.ePersonService.update(this.context, (DSpaceObject)ePerson);
        this.context.restoreAuthSystemState();
        return ePerson;
    }

    protected EPerson createEPersonAndAddToGroup(String email, String firstname, String lastname, Group group) throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = this.createEPerson(email, firstname, lastname);
        this.groupService.addMember(this.context, group, ePerson);
        this.groupService.update(this.context, (DSpaceObject)group);
        this.ePersonService.update(this.context, (DSpaceObject)ePerson);
        this.context.restoreAuthSystemState();
        return ePerson;
    }

    protected EPerson createEPerson(String email) throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = this.ePersonService.create(this.context);
        ePerson.setEmail(email);
        this.ePersonService.update(this.context, (DSpaceObject)ePerson);
        this.context.restoreAuthSystemState();
        return ePerson;
    }

    protected EPerson createEPerson(String email, String firstname, String lastname) throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = this.ePersonService.create(this.context);
        ePerson.setEmail(email);
        ePerson.setFirstName(this.context, firstname);
        ePerson.setLastName(this.context, lastname);
        this.ePersonService.update(this.context, (DSpaceObject)ePerson);
        this.context.restoreAuthSystemState();
        return ePerson;
    }
}

