/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.ConditionEqualJsonPathMetadataContributor;
import org.dspace.importer.external.metadatamapping.contributor.JsonPathMetadataProcessor;
import org.dspace.importer.external.metadatamapping.contributor.SimpleJsonPathMetadataContributor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ConditionEqualJsonPathMetadataContributorTest {
    private final String json = "{\"field\": \"expectedValue\"}";
    @Mock
    private JsonPathMetadataProcessor leftOperandProcessor;
    @Mock
    private SimpleJsonPathMetadataContributor metadatumContributor;
    @InjectMocks
    private ConditionEqualJsonPathMetadataContributor contributor;

    @Before
    public void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        this.contributor.setRightOperand("expectedValue");
    }

    @Test
    public void testContributeMetadata_MatchingCondition() {
        Mockito.when((Object)this.leftOperandProcessor.processMetadata("{\"field\": \"expectedValue\"}")).thenReturn(Collections.singleton("expectedValue"));
        List<MetadatumDTO> expectedMetadata = List.of(new MetadatumDTO());
        Mockito.when((Object)this.metadatumContributor.contributeMetadata("{\"field\": \"expectedValue\"}")).thenReturn(expectedMetadata);
        Collection result = this.contributor.contributeMetadata("{\"field\": \"expectedValue\"}");
        Assert.assertEquals(expectedMetadata, (Object)result);
    }

    @Test
    public void testContributeMetadata_NonMatchingCondition() {
        Mockito.when((Object)this.leftOperandProcessor.processMetadata("{\"field\": \"expectedValue\"}")).thenReturn(Collections.singleton("unexpectedValue"));
        Collection result = this.contributor.contributeMetadata("{\"field\": \"expectedValue\"}");
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testContributeMetadata_EmptyOperands() {
        Mockito.when((Object)this.leftOperandProcessor.processMetadata("{\"field\": \"expectedValue\"}")).thenReturn(Collections.emptyList());
        Collection result = this.contributor.contributeMetadata("{\"field\": \"expectedValue\"}");
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testContributeMetadata_NullOperands() {
        Mockito.when((Object)this.leftOperandProcessor.processMetadata("{\"field\": \"expectedValue\"}")).thenReturn(null);
        Collection result = this.contributor.contributeMetadata("{\"field\": \"expectedValue\"}");
        Assert.assertTrue((boolean)result.isEmpty());
    }
}

