/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.dspace.importer.external.metadatamapping.contributor.InvertedIndexProcessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InvertedIndexProcessorTest {
    private InvertedIndexProcessor processor;
    private ObjectMapper objectMapper;

    @Before
    public void setUp() {
        this.processor = new InvertedIndexProcessor();
        this.processor.setPath("/index");
        this.objectMapper = new ObjectMapper();
    }

    @Test
    public void testGetStringValue_NullNode_ReturnsEmptyString() {
        Assert.assertEquals((Object)"", (Object)this.processor.getStringValue(null));
    }

    @Test
    public void testGetStringValue_EmptyNode_ReturnsEmptyString() throws IOException {
        JsonNode emptyNode = this.objectMapper.readTree("{}");
        Assert.assertEquals((Object)"", (Object)this.processor.getStringValue(emptyNode));
    }

    @Test
    public void testGetStringValue_MissingPath_ReturnsEmptyString() throws IOException {
        JsonNode jsonNode = this.objectMapper.readTree("{\"wrongPath\": { \"1\": \"word\" }}");
        Assert.assertEquals((Object)"", (Object)this.processor.getStringValue(jsonNode));
    }

    @Test
    public void testGetStringValue_InvalidStructure_ReturnsEmptyString() throws IOException {
        JsonNode jsonNode = this.objectMapper.readTree("{\"index\": \"not an object or array\"}");
        Assert.assertEquals((Object)"", (Object)this.processor.getStringValue(jsonNode));
    }

    @Test
    public void testGetStringValue_ValidJson_ReturnsOrderedString() throws IOException {
        String json = "{ \"index\": { \"word1\": [2, 5], \"word2\": [1], \"word3\": [4] } }";
        JsonNode jsonNode = this.objectMapper.readTree(json);
        Assert.assertEquals((Object)"word2 word1 word3 word1", (Object)this.processor.getStringValue(jsonNode));
    }

    @Test
    public void testGetStringValue_UnorderedJson_ReturnsCorrectlyOrderedString() throws IOException {
        String json = "{ \"index\": { \"apple\": [3], \"banana\": [1], \"cherry\": [2] } }";
        JsonNode jsonNode = this.objectMapper.readTree(json);
        Assert.assertEquals((Object)"banana cherry apple", (Object)this.processor.getStringValue(jsonNode));
    }
}

