/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.MetadataContributor;
import org.dspace.importer.external.metadatamapping.contributor.MultipleMetadataContributor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class MultipleMetadataContributorTest {
    private MultipleMetadataContributor<Object> multipleMetadataContributor;
    private MetadataFieldConfig field;
    private MetadataContributor<Object> contributor1;
    private MetadataContributor<Object> contributor2;

    @Before
    public void setUp() {
        this.field = new MetadataFieldConfig("dc", "title", null);
        this.contributor1 = (MetadataContributor)Mockito.mock(MetadataContributor.class);
        this.contributor2 = (MetadataContributor)Mockito.mock(MetadataContributor.class);
        this.multipleMetadataContributor = new MultipleMetadataContributor(this.field, new LinkedList<MetadataContributor>(Arrays.asList(this.contributor1, this.contributor2)));
    }

    @Test
    public void testContributeMetadataWithoutDuplicates() {
        MetadatumDTO dto1 = new MetadatumDTO();
        dto1.setValue("Value1");
        MetadatumDTO dto2 = new MetadatumDTO();
        dto2.setValue("Value2");
        Mockito.when((Object)this.contributor1.contributeMetadata(Mockito.any())).thenReturn(List.of(dto1));
        Mockito.when((Object)this.contributor2.contributeMetadata(Mockito.any())).thenReturn(List.of(dto2));
        Collection result = this.multipleMetadataContributor.contributeMetadata(new Object());
        Assert.assertEquals((long)2L, (long)result.size());
    }

    @Test
    public void testContributeMetadataWithDuplicates() {
        MetadatumDTO dto1 = new MetadatumDTO();
        dto1.setValue("DuplicateValue");
        MetadatumDTO dto2 = new MetadatumDTO();
        dto2.setValue("DuplicateValue");
        Mockito.when((Object)this.contributor1.contributeMetadata(Mockito.any())).thenReturn(List.of(dto1));
        Mockito.when((Object)this.contributor2.contributeMetadata(Mockito.any())).thenReturn(List.of(dto2));
        this.multipleMetadataContributor.setEnsureUniqueValues(true);
        Collection result = this.multipleMetadataContributor.contributeMetadata(new Object());
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testContributeMetadataWithEmptyContributors() {
        this.multipleMetadataContributor = new MultipleMetadataContributor(this.field, new LinkedList());
        Collection result = this.multipleMetadataContributor.contributeMetadata(new Object());
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testContributeMetadataWithNullValues() {
        MetadatumDTO dto1 = new MetadatumDTO();
        dto1.setValue(null);
        MetadatumDTO dto2 = new MetadatumDTO();
        dto2.setValue("ValidValue");
        Mockito.when((Object)this.contributor1.contributeMetadata(Mockito.any())).thenReturn(List.of(dto1));
        Mockito.when((Object)this.contributor2.contributeMetadata(Mockito.any())).thenReturn(List.of(dto2));
        Collection result = this.multipleMetadataContributor.contributeMetadata(new Object());
        Assert.assertEquals((long)2L, (long)result.size());
    }
}

