/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matcher;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class DateMatcher
extends BaseMatcher<String> {
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ISO_ZONED_DATE_TIME;
    private final ZonedDateTime matchDate;

    public DateMatcher(ZonedDateTime matchDate) {
        this.matchDate = matchDate != null ? matchDate.truncatedTo(ChronoUnit.SECONDS) : null;
    }

    public boolean matches(Object testDate) {
        ZonedDateTime testDateDecoded;
        if (null == this.matchDate && null == testDate) {
            return true;
        }
        if (null == this.matchDate) {
            return false;
        }
        if (!(testDate instanceof String)) {
            throw new IllegalArgumentException("Argument not a String");
        }
        try {
            testDateDecoded = ZonedDateTime.parse((String)testDate, dateFormat).truncatedTo(ChronoUnit.SECONDS);
        }
        catch (DateTimeParseException ex) {
            throw new IllegalArgumentException("Argument '" + testDate + "' is not an ISO 8601 zoned date", ex);
        }
        return this.matchDate.equals(testDateDecoded);
    }

    public void describeTo(Description description) {
        description.appendText("is the same date as ");
        description.appendText(this.matchDate != null ? dateFormat.format(this.matchDate) : "null");
    }

    public static DateMatcher dateMatcher(ZonedDateTime matchDate) {
        return new DateMatcher(matchDate);
    }
}

