/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo;

import org.dspace.AbstractUnitTest;
import org.dspace.matomo.MatomoSyncEventHandler;
import org.dspace.matomo.client.MatomoClient;
import org.dspace.matomo.model.MatomoRequestDetails;
import org.dspace.matomo.model.MatomoRequestDetailsBuilder;
import org.dspace.usage.UsageEvent;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MatomoSyncEventHandlerTest
extends AbstractUnitTest {
    @Mock
    MatomoClient matomoClient;
    @Mock
    MatomoRequestDetailsBuilder builder;
    @InjectMocks
    MatomoSyncEventHandler matomoSyncEventHandler;

    @Test
    public void testNullEvent() {
        this.matomoSyncEventHandler.handleEvent(null);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.builder});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.matomoClient});
    }

    @Test
    public void testSingleEvent() {
        UsageEvent usageEvent = (UsageEvent)Mockito.mock(UsageEvent.class);
        MatomoRequestDetails matomoRequestDetails = new MatomoRequestDetails();
        Mockito.when((Object)this.builder.build(usageEvent)).thenReturn((Object)matomoRequestDetails);
        this.matomoSyncEventHandler.handleEvent(usageEvent);
        ((MatomoClient)Mockito.verify((Object)this.matomoClient, (VerificationMode)Mockito.times((int)1))).sendDetails(new MatomoRequestDetails[]{matomoRequestDetails});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.matomoClient});
    }

    @Test
    public void testMultipleEvents() {
        UsageEvent usageEvent1 = (UsageEvent)Mockito.mock(UsageEvent.class);
        UsageEvent usageEvent2 = (UsageEvent)Mockito.mock(UsageEvent.class);
        UsageEvent usageEvent3 = (UsageEvent)Mockito.mock(UsageEvent.class);
        MatomoRequestDetails matomoRequestDetails1 = new MatomoRequestDetails();
        MatomoRequestDetails matomoRequestDetails2 = new MatomoRequestDetails();
        MatomoRequestDetails matomoRequestDetails3 = new MatomoRequestDetails();
        Mockito.when((Object)this.builder.build(usageEvent1)).thenReturn((Object)matomoRequestDetails1);
        Mockito.when((Object)this.builder.build(usageEvent2)).thenReturn((Object)matomoRequestDetails2);
        Mockito.when((Object)this.builder.build(usageEvent3)).thenReturn((Object)matomoRequestDetails3);
        this.matomoSyncEventHandler.handleEvent(usageEvent1);
        this.matomoSyncEventHandler.handleEvent(usageEvent2);
        this.matomoSyncEventHandler.handleEvent(usageEvent3);
        ((MatomoClient)Mockito.verify((Object)this.matomoClient, (VerificationMode)Mockito.times((int)1))).sendDetails(new MatomoRequestDetails[]{matomoRequestDetails1});
        ((MatomoClient)Mockito.verify((Object)this.matomoClient, (VerificationMode)Mockito.times((int)1))).sendDetails(new MatomoRequestDetails[]{matomoRequestDetails2});
        ((MatomoClient)Mockito.verify((Object)this.matomoClient, (VerificationMode)Mockito.times((int)1))).sendDetails(new MatomoRequestDetails[]{matomoRequestDetails3});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.matomoClient});
    }
}

