/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo.client;

import org.dspace.AbstractUnitTest;
import org.dspace.matomo.client.MatomoResponse;
import org.dspace.matomo.client.MatomoResponseReader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

public class MatomoResponseReaderTest
extends AbstractUnitTest {
    MatomoResponseReader matomoResponseReader;

    @Before
    public void setUp() throws Exception {
        this.matomoResponseReader = new MatomoResponseReader();
    }

    @Test
    public void testReadNullResponse() {
        MatcherAssert.assertThat((Object)this.matomoResponseReader.fromJSON(null), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testReadEmptyResponse() {
        MatomoResponse actual = this.matomoResponseReader.fromJSON("");
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testReadEmptyJsonResponse() {
        MatomoResponse actual = this.matomoResponseReader.fromJSON("{}");
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)actual.status(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)actual.tracked(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)actual.invalid(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)actual.invalidIndices(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testReadSuccessResponse() {
        MatomoResponse actual = this.matomoResponseReader.fromJSON("{\"status\":\"success\",\"tracked\":1,\"invalid\":0,\"invalid_indices\":[]}");
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)actual.status(), (Matcher)CoreMatchers.is((Object)"success"));
        MatcherAssert.assertThat((Object)actual.tracked(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)actual.invalid(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)actual.invalidIndices(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)actual.invalidIndices().length, (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testReadFailedResponse() {
        MatomoResponse actual = this.matomoResponseReader.fromJSON("{\"status\":\"success\",\"tracked\":0,\"invalid\":1,\"invalid_indices\":[0]}");
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)actual.status(), (Matcher)CoreMatchers.is((Object)"success"));
        MatcherAssert.assertThat((Object)actual.tracked(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)actual.invalid(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)actual.invalidIndices(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)actual.invalidIndices().length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)actual.invalidIndices()[0], (Matcher)CoreMatchers.is((Object)0));
    }
}

