/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo.model;

import java.util.List;
import java.util.Map;
import org.dspace.AbstractUnitTest;
import org.dspace.matomo.model.MatomoRequestDetails;
import org.dspace.matomo.model.MatomoRequestDetailsSplitter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class MatomoRequestDetailsSplitterTest
extends AbstractUnitTest {
    @Test
    public void testMatomoRequestDetailsSingleRequest() {
        Map split = MatomoRequestDetailsSplitter.split(List.of(new MatomoRequestDetails().addParameter("_id", "first").addParameter("param1", "value1")));
        MatcherAssert.assertThat(split.keySet(), (Matcher)CoreMatchers.hasItem((Object)"first"));
        MatcherAssert.assertThat((Object)((MatomoRequestDetails)((List)split.get((Object)"first")).get((int)0)).parameters, (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)"_id", (Object)"first"), Matchers.hasEntry((Object)"param1", (Object)"value1")}));
    }

    @Test
    public void testMatomoRequestDetailsNoIdRequest() {
        Map split = MatomoRequestDetailsSplitter.split(List.of(new MatomoRequestDetails().addParameter("param1", "value1").addParameter("param2", "value2")));
        MatcherAssert.assertThat(split.keySet(), (Matcher)CoreMatchers.hasItem((Object)"default"));
        MatcherAssert.assertThat((Object)((MatomoRequestDetails)((List)split.get((Object)"default")).get((int)0)).parameters, (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Object)"param2", (Object)"value2"), Matchers.hasEntry((Object)"param1", (Object)"value1")}));
    }

    @Test
    public void testMatomoMultipleRequests() {
        Map split = MatomoRequestDetailsSplitter.split(List.of(new MatomoRequestDetails().addParameter("_id", "first").addParameter("param2", "value2"), new MatomoRequestDetails().addParameter("_id", "first").addParameter("param1", "value1")));
        MatcherAssert.assertThat(split.keySet(), (Matcher)Matchers.hasItem((Object)"first"));
        MatcherAssert.assertThat(split.keySet(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"default")));
        MatcherAssert.assertThat((Object)((MatomoRequestDetails)((List)split.get((Object)"first")).get((int)0)).parameters, (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"param2", (Object)"value2"), (Matcher)Matchers.hasEntry((Object)"_id", (Object)"first")));
        MatcherAssert.assertThat((Object)((MatomoRequestDetails)((List)split.get((Object)"first")).get((int)1)).parameters, (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"param1", (Object)"value1"), (Matcher)Matchers.hasEntry((Object)"_id", (Object)"first")));
    }

    @Test
    public void testMatomoMultipleRequestsNoId() {
        Map split = MatomoRequestDetailsSplitter.split(List.of(new MatomoRequestDetails().addParameter("_id", "first").addParameter("param2", "value2"), new MatomoRequestDetails().addParameter("_id", "first").addParameter("param1", "value1"), new MatomoRequestDetails().addParameter("param3", "value3").addParameter("param4", "value4")));
        MatcherAssert.assertThat(split.keySet(), (Matcher)Matchers.hasItem((Object)"first"));
        MatcherAssert.assertThat(split.keySet(), (Matcher)Matchers.hasItem((Object)"default"));
        MatcherAssert.assertThat((Object)((MatomoRequestDetails)((List)split.get((Object)"first")).get((int)0)).parameters, (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"param2", (Object)"value2"), (Matcher)Matchers.hasEntry((Object)"_id", (Object)"first")));
        MatcherAssert.assertThat((Object)((MatomoRequestDetails)((List)split.get((Object)"first")).get((int)1)).parameters, (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"param1", (Object)"value1"), (Matcher)Matchers.hasEntry((Object)"_id", (Object)"first")));
        MatcherAssert.assertThat((Object)((MatomoRequestDetails)((List)split.get((Object)"default")).get((int)0)).parameters, (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"param3", (Object)"value3"), (Matcher)Matchers.hasEntry((Object)"param4", (Object)"value4")));
    }
}

