/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.dspace.solr.MockSolrServer;
import org.dspace.statistics.SolrClientFactory;

public class EmbeddedSolrClientFactory
implements SolrClientFactory {
    private static final Logger log = LogManager.getLogger();
    private String coreName;
    private SolrClient solrClient = null;
    private MockSolrServer mockSolrServer;

    public SolrClient getClient(String coreUrl) {
        try {
            this.coreName = Path.of(new URL(coreUrl).getPath(), new String[0]).getFileName().toString();
        }
        catch (MalformedURLException ex) {
            log.warn("Unable to extract core name from URI '{}':  {}", (Object)coreUrl, (Object)ex.getMessage());
        }
        try {
            this.mockSolrServer = new MockSolrServer(this.coreName);
            this.solrClient = this.mockSolrServer.getSolrServer();
        }
        catch (Exception ex) {
            log.warn("Failed to instantiate a MockSolrServer", (Throwable)ex);
            this.solrClient = null;
        }
        return this.solrClient;
    }

    public void reset() {
        this.mockSolrServer.reset();
    }

    public void destroy() throws Exception {
        this.mockSolrServer.destroy();
    }
}

