/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.export.processor;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.codec.CharEncoding;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.statistics.export.processor.ItemEventProcessor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;

public class ItemEventProcessorIT
extends AbstractIntegrationTestWithDatabase {
    private final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private String encodedUrl;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.configurationService.setProperty("irus.statistics.tracker.enabled", (Object)true);
        String dspaceUrl = this.configurationService.getProperty("dspace.ui.url");
        try {
            this.encodedUrl = URLEncoder.encode(dspaceUrl, CharEncoding.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("Error occurred in setup()", e);
        }
    }

    @Test
    public void testAddObectSpecificData() throws UnsupportedEncodingException {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        this.context.restoreAuthSystemState();
        String encodedHandle = URLEncoder.encode(item.getHandle(), CharEncoding.UTF_8);
        ItemEventProcessor itemEventProcessor = new ItemEventProcessor(this.context, null, item);
        String result = itemEventProcessor.addObjectSpecificData("existing-string", item);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)("existing-string&svc_dat=" + this.encodedUrl + "%2Fhandle%2F" + encodedHandle + "&rft_dat=Investigation")));
    }
}

