/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.bitstore;

import com.google.common.io.ByteSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.dspace.AbstractUnitTest;
import org.dspace.content.Bitstream;
import org.dspace.storage.bitstore.JCloudBitStoreService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.io.Payload;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class JCloudBitStoreServiceTest
extends AbstractUnitTest {
    private JCloudBitStoreService jCloudBitStoreService;
    @Mock
    private BlobStoreContext blobStoreContext;
    @Mock
    private BlobStore blobStore;
    @Mock
    private Bitstream bitstream;

    @Before
    public void setUp() throws Exception {
        this.jCloudBitStoreService = new JCloudBitStoreService(this.blobStoreContext, "filesystem");
    }

    @Test
    public void getBitstreamTest() throws Exception {
        Blob blob = (Blob)Mockito.mock(Blob.class);
        Payload payload = (Payload)Mockito.mock(Payload.class);
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)blob.getPayload()).thenReturn((Object)payload);
        Mockito.when((Object)payload.openStream()).thenReturn((Object)inputStream);
        Mockito.when((Object)this.blobStoreContext.getBlobStore()).thenReturn((Object)this.blobStore);
        Mockito.when((Object)this.blobStore.getBlob((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)blob);
        Mockito.when((Object)this.blobStore.blobExists((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)true);
        MatcherAssert.assertThat((Object)this.jCloudBitStoreService.get(this.bitstream), (Matcher)Matchers.equalTo((Object)inputStream));
    }

    @Test
    public void removeBitstreamTest() throws Exception {
        String bitStreamId = "BitStreamId";
        Mockito.when((Object)this.bitstream.getInternalId()).thenReturn((Object)bitStreamId);
        Mockito.when((Object)this.blobStoreContext.getBlobStore()).thenReturn((Object)this.blobStore);
        try {
            this.jCloudBitStoreService.remove(this.bitstream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((BlobStore)Mockito.verify((Object)this.blobStore, (VerificationMode)Mockito.times((int)1))).removeBlob((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    @Test
    public void replaceBitStreamTest() throws Exception {
        Blob blob = (Blob)Mockito.mock(Blob.class);
        File file = (File)Mockito.mock(File.class);
        BlobBuilder blobBuilder = (BlobBuilder)Mockito.mock(BlobBuilder.class);
        BlobBuilder.PayloadBlobBuilder payloadBlobBuilder = (BlobBuilder.PayloadBlobBuilder)Mockito.mock(BlobBuilder.PayloadBlobBuilder.class);
        Mockito.when((Object)this.blobStoreContext.getBlobStore()).thenReturn((Object)this.blobStore);
        Mockito.when((Object)this.blobStore.blobBuilder((String)ArgumentMatchers.any())).thenReturn((Object)blobBuilder);
        Mockito.when((Object)blobBuilder.payload((ByteSource)ArgumentMatchers.any(ByteSource.class))).thenReturn((Object)payloadBlobBuilder);
        Mockito.when((Object)payloadBlobBuilder.contentDisposition((String)ArgumentMatchers.any())).thenReturn((Object)payloadBlobBuilder);
        Mockito.when((Object)payloadBlobBuilder.contentLength(((Long)ArgumentMatchers.any(Long.TYPE)).longValue())).thenReturn((Object)payloadBlobBuilder);
        Mockito.when((Object)payloadBlobBuilder.contentType((String)ArgumentMatchers.any(String.class))).thenReturn((Object)payloadBlobBuilder);
        Mockito.when((Object)payloadBlobBuilder.build()).thenReturn((Object)blob);
        ByteSource byteSource = (ByteSource)Mockito.mock(ByteSource.class);
        String mockedTag = "1a7771d5fdd7bfdfc84033c70b1ba555";
        this.jCloudBitStoreService.put(byteSource, this.bitstream);
        ((BlobStore)Mockito.verify((Object)this.blobStore, (VerificationMode)Mockito.times((int)1))).putBlob((String)ArgumentMatchers.any(), (Blob)ArgumentMatchers.any(), (PutOptions)ArgumentMatchers.any());
    }

    @Test
    public void givenBitStreamIdentifierLongerThanPossibleWhenIntermediatePathIsComputedThenIsSplittedAndTruncated() {
        String path = "01234567890123456789";
        String computedPath = this.jCloudBitStoreService.getIntermediatePath(path);
        String expectedPath = "01" + File.separator + "23" + File.separator + "45" + File.separator;
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.equalTo((Object)expectedPath));
    }

    @Test
    public void givenBitStreamIdentifierShorterThanAFolderLengthWhenIntermediatePathIsComputedThenIsSingleFolder() {
        String path = "0";
        String computedPath = this.jCloudBitStoreService.getIntermediatePath(path);
        String expectedPath = "0" + File.separator;
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.equalTo((Object)expectedPath));
    }

    @Test
    public void givenPartialBitStreamIdentifierWhenIntermediatePathIsComputedThenIsCompletlySplitted() {
        String path = "01234";
        String computedPath = this.jCloudBitStoreService.getIntermediatePath(path);
        String expectedPath = "01" + File.separator + "23" + File.separator + "4" + File.separator;
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.equalTo((Object)expectedPath));
    }

    @Test
    public void givenMaxLengthBitStreamIdentifierWhenIntermediatePathIsComputedThenIsSplittedAllAsSubfolder() {
        String path = "012345";
        String computedPath = this.jCloudBitStoreService.getIntermediatePath(path);
        String expectedPath = "01" + File.separator + "23" + File.separator + "45" + File.separator;
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.equalTo((Object)expectedPath));
    }

    @Test
    public void givenBitStreamIdentifierWhenIntermediatePathIsComputedThenNotEndingDoubleSlash() throws IOException {
        StringBuilder path = new StringBuilder("01");
        String computedPath = this.jCloudBitStoreService.getIntermediatePath(path.toString());
        int slashes = this.computeSlashes(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.endsWith((String)File.separator));
        MatcherAssert.assertThat((Object)computedPath.split(File.separator).length, (Matcher)Matchers.equalTo((Object)slashes));
        path.append("2");
        computedPath = this.jCloudBitStoreService.getIntermediatePath(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.not((Matcher)Matchers.endsWith((String)(File.separator + File.separator))));
        path.append("3");
        computedPath = this.jCloudBitStoreService.getIntermediatePath(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.not((Matcher)Matchers.endsWith((String)(File.separator + File.separator))));
        path.append("4");
        computedPath = this.jCloudBitStoreService.getIntermediatePath(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.not((Matcher)Matchers.endsWith((String)(File.separator + File.separator))));
        path.append("56789");
        computedPath = this.jCloudBitStoreService.getIntermediatePath(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.not((Matcher)Matchers.endsWith((String)(File.separator + File.separator))));
    }

    @Test
    public void givenBitStreamIdentidierWhenIntermediatePathIsComputedThenMustBeSplitted() throws IOException {
        StringBuilder path = new StringBuilder("01");
        String computedPath = this.jCloudBitStoreService.getIntermediatePath(path.toString());
        int slashes = this.computeSlashes(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.endsWith((String)File.separator));
        MatcherAssert.assertThat((Object)computedPath.split(File.separator).length, (Matcher)Matchers.equalTo((Object)slashes));
        path.append("2");
        computedPath = this.jCloudBitStoreService.getIntermediatePath(path.toString());
        slashes = this.computeSlashes(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.endsWith((String)File.separator));
        MatcherAssert.assertThat((Object)computedPath.split(File.separator).length, (Matcher)Matchers.equalTo((Object)slashes));
        path.append("3");
        computedPath = this.jCloudBitStoreService.getIntermediatePath(path.toString());
        slashes = this.computeSlashes(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.endsWith((String)File.separator));
        MatcherAssert.assertThat((Object)computedPath.split(File.separator).length, (Matcher)Matchers.equalTo((Object)slashes));
        path.append("4");
        computedPath = this.jCloudBitStoreService.getIntermediatePath(path.toString());
        slashes = this.computeSlashes(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.endsWith((String)File.separator));
        MatcherAssert.assertThat((Object)computedPath.split(File.separator).length, (Matcher)Matchers.equalTo((Object)slashes));
        path.append("56789");
        computedPath = this.jCloudBitStoreService.getIntermediatePath(path.toString());
        slashes = this.computeSlashes(path.toString());
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.endsWith((String)File.separator));
        MatcherAssert.assertThat((Object)computedPath.split(File.separator).length, (Matcher)Matchers.equalTo((Object)slashes));
    }

    @Test
    public void givenBitStreamIdentifierWithSlashesWhenSanitizedThenSlashesMustBeRemoved() {
        String sInternalId = "01" + File.separator + "22" + File.separator + "33" + File.separator + "4455";
        String computedPath = this.jCloudBitStoreService.sanitizeIdentifier(sInternalId);
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.not((Matcher)Matchers.startsWith((String)File.separator)));
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.not((Matcher)Matchers.endsWith((String)File.separator)));
        MatcherAssert.assertThat((Object)computedPath, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)File.separator)));
    }

    private int computeSlashes(String internalId) {
        int minimum = internalId.length();
        int slashesPerLevel = minimum / 2;
        int odd = Math.min(1, minimum % 2);
        int slashes = slashesPerLevel + odd;
        return Math.min(slashes, 3);
    }
}

