/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.util;

import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import org.dspace.util.MultiFormatDateParser;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MultiFormatDateParserTest {
    private static Locale vmLocale;
    private final String toParseDate;
    private final String expectedFormat;
    private final String expectedResult;

    public MultiFormatDateParserTest(String toParseDate, String expectedFormat, String expectedResult) {
        this.toParseDate = toParseDate;
        this.expectedFormat = expectedFormat;
        this.expectedResult = expectedResult;
    }

    @Parameterized.Parameters
    public static Collection dateFormatsToTest() {
        return Arrays.asList({"19570127", "yyyyMMdd", "1957-01-27T00:00Z"}, {"27-01-1957", "dd-MM-yyyy", "1957-01-27T00:00Z"}, {"1957-01-27", "yyyy-MM-dd", "1957-01-27T00:00Z"}, {"01/27/1957", "MM/dd/yyyy", "1957-01-27T00:00Z"}, {"1957/01/27", "yyyy/MM/dd", "1957-01-27T00:00Z"}, {"195701272006", "yyyyMMddHHmm", "1957-01-27T20:06Z"}, {"19570127 2006", "yyyyMMdd HHmm", "1957-01-27T20:06Z"}, {"27-01-1957 20:06", "dd-MM-yyyy HH:mm", "1957-01-27T20:06Z"}, {"1957-01-27 20:06", "yyyy-MM-dd HH:mm", "1957-01-27T20:06Z"}, {"01/27/1957 20:06", "MM/dd/yyyy HH:mm", "1957-01-27T20:06Z"}, {"1957/01/27 20:06", "yyyy/MM/dd HH:mm", "1957-01-27T20:06Z"}, {"19570127200620", "yyyyMMddHHmmss", "1957-01-27T20:06:20Z"}, {"19570127 200620", "yyyyMMdd HHmmss", "1957-01-27T20:06:20Z"}, {"27-01-1957 20:06:20", "dd-MM-yyyy HH:mm:ss", "1957-01-27T20:06:20Z"}, {"01/27/1957 20:06:20", "MM/dd/yyyy HH:mm:ss", "1957-01-27T20:06:20Z"}, {"1957/01/27 20:06:20", "yyyy/MM/dd HH:mm:ss", "1957-01-27T20:06:20Z"}, {"1957 Jan 27", "yyyy MMM dd", "1957-01-27T00:00Z"}, {"1957-01", "yyyy-MM", "1957-01-01T00:00Z"}, {"195701", "yyyyMM", "1957-01-01T00:00Z"}, {"1957", "yyyy", "1957-01-01T00:00Z"}, {"1957-01-27T12:34:56Z", "yyyy-MM-dd'T'HH:mm:ss'Z'", "1957-01-27T12:34:56Z"}, {"1957-01-27T12:34:56.789Z", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "1957-01-27T12:34:56.789Z"}, {"1957/01/2720:06:20", "yyyy/MM/ddHH:mm:ss", ""});
    }

    @BeforeClass
    public static void setUpClass() {
        HashMap<String, String> formats = new HashMap<String, String>(32);
        formats.put("\\d{8}", "yyyyMMdd");
        formats.put("\\d{1,2}-\\d{1,2}-\\d{4}", "dd-MM-yyyy");
        formats.put("\\d{4}-\\d{1,2}-\\d{1,2}", "yyyy-MM-dd");
        formats.put("\\d{4}-\\d{1,2}", "yyyy-MM");
        formats.put("\\d{1,2}/\\d{1,2}/\\d{4}", "MM/dd/yyyy");
        formats.put("\\d{4}/\\d{1,2}/\\d{1,2}", "yyyy/MM/dd");
        formats.put("\\d{1,2}\\s[a-z]{3}\\s\\d{4}", "dd MMM yyyy");
        formats.put("\\d{1,2}\\s[a-z]{4,}\\s\\d{4}", "dd MMMM yyyy");
        formats.put("\\d{12}", "yyyyMMddHHmm");
        formats.put("\\d{8}\\s\\d{4}", "yyyyMMdd HHmm");
        formats.put("\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{2}", "dd-MM-yyyy HH:mm");
        formats.put("\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}", "yyyy-MM-dd HH:mm");
        formats.put("\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{2}", "MM/dd/yyyy HH:mm");
        formats.put("\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}", "yyyy/MM/dd HH:mm");
        formats.put("\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{2}", "dd MMM yyyy HH:mm");
        formats.put("\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{2}", "dd MMMM yyyy HH:mm");
        formats.put("\\d{4}\\s[a-z]{3}\\s\\d{1,2}", "yyyy MMM dd");
        formats.put("\\d{14}", "yyyyMMddHHmmss");
        formats.put("\\d{6}", "yyyyMM");
        formats.put("\\d{4}", "yyyy");
        formats.put("\\d{8}\\s\\d{6}", "yyyyMMdd HHmmss");
        formats.put("\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}", "dd-MM-yyyy HH:mm:ss");
        formats.put("\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}", "yyyy-MM-dd HH:mm:ss");
        formats.put("\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}", "MM/dd/yyyy HH:mm:ss");
        formats.put("\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}", "yyyy/MM/dd HH:mm:ss");
        formats.put("\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}", "dd MMM yyyy HH:mm:ss");
        formats.put("\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}", "dd MMMM yyyy HH:mm:ss");
        formats.put("\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{2}:\\d{2}Z", "yyyy-MM-dd'T'HH:mm:ss'Z'");
        formats.put("\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}Z", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        new MultiFormatDateParser().setPatterns(formats);
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testParse() {
        ZonedDateTime result = MultiFormatDateParser.parse((String)this.toParseDate);
        if (!this.expectedResult.isEmpty()) {
            Assert.assertEquals((String)("Should parse: " + this.expectedFormat), (Object)this.expectedResult, (Object)result.toString());
        } else {
            Assert.assertNull((String)("Should not parse: " + this.expectedFormat), (Object)result);
        }
    }
}

