/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.suggestion;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.dspace.app.suggestion.SolrSuggestionStorageService;
import org.dspace.app.suggestion.Suggestion;
import org.dspace.app.suggestion.SuggestionEvidence;
import org.dspace.app.suggestion.SuggestionTarget;
import org.dspace.content.Item;
import org.dspace.content.dto.MetadataValueDTO;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.util.UUIDUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrSuggestionStorageServiceImpl
implements SolrSuggestionStorageService {
    private static final Logger log = LogManager.getLogger(SolrSuggestionStorageServiceImpl.class);
    protected SolrClient solrSuggestionClient;
    @Autowired
    private ItemService itemService;

    protected SolrClient getSolr() {
        if (this.solrSuggestionClient == null) {
            String solrService = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("suggestion.solr.server", "http://localhost:8983/solr/suggestion");
            this.solrSuggestionClient = new HttpSolrClient.Builder(solrService).build();
        }
        return this.solrSuggestionClient;
    }

    @Override
    public void addSuggestion(Suggestion suggestion, boolean force, boolean commit) throws SolrServerException, IOException {
        if (force || !this.exist(suggestion)) {
            JsonMapper jsonMapper = new JsonMapper();
            jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            SolrInputDocument document = new SolrInputDocument(new String[0]);
            document.addField("source", (Object)suggestion.getSource());
            String suggestionFullID = suggestion.getID();
            document.addField("suggestion_fullid", (Object)suggestionFullID);
            document.addField("suggestion_id", (Object)suggestionFullID.split(":", 3)[2]);
            document.addField("target_id", (Object)suggestion.getTarget().getID().toString());
            document.addField("display", (Object)suggestion.getDisplay());
            document.addField("title", (Object)this.getFirstValue(suggestion, "dc", "title", null));
            document.addField("date", (Object)this.getFirstValue(suggestion, "dc", "date", "issued"));
            document.addField("contributors", this.getAllValues(suggestion, "dc", "contributor", "author"));
            document.addField("abstract", (Object)this.getFirstValue(suggestion, "dc", "description", "abstract"));
            document.addField("category", this.getAllValues(suggestion, "dc", "source", null));
            document.addField("external-uri", (Object)suggestion.getExternalSourceUri());
            document.addField("trust", (Object)suggestion.getScore());
            document.addField("processed", (Object)false);
            document.addField("evidences", (Object)jsonMapper.writeValueAsString(suggestion.getEvidences()));
            this.getSolr().add(document);
            if (commit) {
                this.getSolr().commit();
            }
        }
    }

    @Override
    public void commit() throws SolrServerException, IOException {
        this.getSolr().commit();
    }

    private List<String> getAllValues(Suggestion suggestion, String schema, String element, String qualifier) {
        return suggestion.getMetadata().stream().filter(st -> StringUtils.isNotBlank((CharSequence)st.getValue()) && StringUtils.equals((CharSequence)st.getSchema(), (CharSequence)schema) && StringUtils.equals((CharSequence)st.getElement(), (CharSequence)element) && StringUtils.equals((CharSequence)st.getQualifier(), (CharSequence)qualifier)).map(st -> st.getValue()).collect(Collectors.toList());
    }

    private String getFirstValue(Suggestion suggestion, String schema, String element, String qualifier) {
        return suggestion.getMetadata().stream().filter(st -> StringUtils.isNotBlank((CharSequence)st.getValue()) && StringUtils.equals((CharSequence)st.getSchema(), (CharSequence)schema) && StringUtils.equals((CharSequence)st.getElement(), (CharSequence)element) && StringUtils.equals((CharSequence)st.getQualifier(), (CharSequence)qualifier)).map(st -> st.getValue()).findFirst().orElse(null);
    }

    @Override
    public boolean exist(Suggestion suggestion) throws SolrServerException, IOException {
        SolrQuery query = new SolrQuery("suggestion_fullid:\"" + suggestion.getID() + "\" AND processed:true");
        return this.getSolr().query((SolrParams)query).getResults().getNumFound() == 1L;
    }

    @Override
    public void deleteSuggestion(Suggestion suggestion) throws SolrServerException, IOException {
        this.getSolr().deleteById(suggestion.getID());
        this.getSolr().commit();
    }

    @Override
    public void flagSuggestionAsProcessed(Suggestion suggestion) throws SolrServerException, IOException {
        SolrInputDocument sdoc = new SolrInputDocument(new String[0]);
        sdoc.addField("suggestion_fullid", (Object)suggestion.getID());
        HashMap<String, Boolean> fieldModifier = new HashMap<String, Boolean>(1);
        fieldModifier.put("set", true);
        sdoc.addField("processed", fieldModifier);
        this.getSolr().add(sdoc);
        this.getSolr().commit();
    }

    @Override
    public void flagAllSuggestionAsProcessed(String source, String idPart) throws SolrServerException, IOException {
        SolrQuery query = new SolrQuery("source:" + source + " AND suggestion_id:\"" + idPart + "\"");
        query.setRows(Integer.valueOf(Integer.MAX_VALUE));
        query.setFields(new String[]{"suggestion_fullid"});
        SolrDocumentList results = this.getSolr().query((SolrParams)query).getResults();
        if (results.getNumFound() > 0L) {
            for (SolrDocument rDoc : results) {
                SolrInputDocument sdoc = new SolrInputDocument(new String[0]);
                sdoc.addField("suggestion_fullid", rDoc.getFieldValue("suggestion_fullid"));
                HashMap<String, Boolean> fieldModifier = new HashMap<String, Boolean>(1);
                fieldModifier.put("set", true);
                sdoc.addField("processed", fieldModifier);
                this.getSolr().add(sdoc);
            }
        }
        this.getSolr().commit();
    }

    @Override
    public void deleteTarget(SuggestionTarget target) throws SolrServerException, IOException {
        this.getSolr().deleteByQuery("source:" + target.getSource() + " AND target_id:" + target.getTarget().getID().toString());
        this.getSolr().commit();
    }

    @Override
    public long countAllTargets(Context context, String source) throws SolrServerException, IOException {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setQuery("source:" + source);
        solrQuery.addFilterQuery(new String[]{"processed:false"});
        solrQuery.setFacet(true);
        solrQuery.setFacetMinCount(1);
        solrQuery.addFacetField(new String[]{"target_id"});
        solrQuery.setFacetLimit(Integer.MAX_VALUE);
        QueryResponse response = this.getSolr().query((SolrParams)solrQuery);
        return response.getFacetField("target_id").getValueCount();
    }

    @Override
    public long countUnprocessedSuggestionByTarget(Context context, String source, UUID target) throws SolrServerException, IOException {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setQuery("*:*");
        solrQuery.addFilterQuery(new String[]{"source:" + source, "target_id:" + target.toString(), "processed:false"});
        QueryResponse response = this.getSolr().query((SolrParams)solrQuery);
        return response.getResults().getNumFound();
    }

    @Override
    public List<Suggestion> findAllUnprocessedSuggestions(Context context, String source, UUID target, int pageSize, long offset, boolean ascending) throws SolrServerException, IOException {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRows(Integer.valueOf(pageSize));
        solrQuery.setStart(Integer.valueOf((int)offset));
        solrQuery.setQuery("*:*");
        solrQuery.addFilterQuery(new String[]{"source:" + source, "target_id:" + target.toString(), "processed:false"});
        if (ascending) {
            solrQuery.addSort(SolrQuery.SortClause.asc((String)"trust"));
        } else {
            solrQuery.addSort(SolrQuery.SortClause.desc((String)"trust"));
        }
        solrQuery.addSort(SolrQuery.SortClause.desc((String)"date"));
        solrQuery.addSort(SolrQuery.SortClause.asc((String)"title"));
        QueryResponse response = this.getSolr().query((SolrParams)solrQuery);
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        for (SolrDocument solrDoc : response.getResults()) {
            suggestions.add(this.convertSolrDoc(context, solrDoc, source));
        }
        return suggestions;
    }

    @Override
    public List<SuggestionTarget> findAllTargets(Context context, String source, int pageSize, long offset) throws SolrServerException, IOException {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setQuery("source:" + source);
        solrQuery.addFilterQuery(new String[]{"processed:false"});
        solrQuery.setFacet(true);
        solrQuery.setFacetMinCount(1);
        solrQuery.addFacetField(new String[]{"target_id"});
        solrQuery.setParam("facet.offset", new String[]{String.valueOf(offset)});
        solrQuery.setFacetLimit(pageSize);
        QueryResponse response = this.getSolr().query((SolrParams)solrQuery);
        FacetField facetField = response.getFacetField("target_id");
        ArrayList<SuggestionTarget> suggestionTargets = new ArrayList<SuggestionTarget>();
        int idx = 0;
        for (FacetField.Count c : facetField.getValues()) {
            SuggestionTarget target = new SuggestionTarget();
            target.setSource(source);
            target.setTotal((int)c.getCount());
            target.setTarget(this.findItem(context, c.getName()));
            suggestionTargets.add(target);
            ++idx;
        }
        return suggestionTargets;
    }

    @Override
    public Suggestion findUnprocessedSuggestion(Context context, String source, UUID target, String id) throws SolrServerException, IOException {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRows(Integer.valueOf(1));
        solrQuery.setQuery("*:*");
        solrQuery.addFilterQuery(new String[]{"source:" + source, "target_id:" + target.toString(), "suggestion_id:\"" + id + "\"", "processed:false"});
        SolrDocumentList results = this.getSolr().query((SolrParams)solrQuery).getResults();
        return CollectionUtils.isEmpty((Collection)results) ? null : this.convertSolrDoc(context, (SolrDocument)results.get(0), source);
    }

    @Override
    public SuggestionTarget findTarget(Context context, String source, UUID target) throws SolrServerException, IOException {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setQuery("source:" + source);
        solrQuery.addFilterQuery(new String[]{"target_id:" + target.toString(), "processed:false"});
        QueryResponse response = this.getSolr().query((SolrParams)solrQuery);
        SuggestionTarget sTarget = new SuggestionTarget();
        sTarget.setSource(source);
        sTarget.setTotal((int)response.getResults().getNumFound());
        Item itemTarget = this.findItem(context, target);
        if (itemTarget == null) {
            return null;
        }
        sTarget.setTarget(itemTarget);
        return sTarget;
    }

    private Suggestion convertSolrDoc(Context context, SolrDocument solrDoc, String sourceName) {
        Item target = this.findItem(context, (String)solrDoc.getFieldValue("target_id"));
        Suggestion suggestion = new Suggestion(sourceName, target, (String)solrDoc.getFieldValue("suggestion_id"));
        suggestion.setDisplay((String)solrDoc.getFieldValue("display"));
        suggestion.getMetadata().add(new MetadataValueDTO("dc", "title", null, null, (String)solrDoc.getFieldValue("title")));
        suggestion.getMetadata().add(new MetadataValueDTO("dc", "date", "issued", null, (String)solrDoc.getFieldValue("date")));
        suggestion.getMetadata().add(new MetadataValueDTO("dc", "description", "abstract", null, (String)solrDoc.getFieldValue("abstract")));
        suggestion.setExternalSourceUri((String)solrDoc.getFieldValue("external-uri"));
        if (solrDoc.containsKey((Object)"category")) {
            for (Object o : solrDoc.getFieldValues("category")) {
                suggestion.getMetadata().add(new MetadataValueDTO("dc", "source", null, null, (String)o));
            }
        }
        if (solrDoc.containsKey((Object)"contributors")) {
            for (Object o : solrDoc.getFieldValues("contributors")) {
                suggestion.getMetadata().add(new MetadataValueDTO("dc", "contributor", "author", null, (String)o));
            }
        }
        String evidencesJson = (String)solrDoc.getFieldValue("evidences");
        JsonMapper jsonMapper = new JsonMapper();
        jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        List evidences = new LinkedList();
        try {
            evidences = (List)jsonMapper.readValue(evidencesJson, (TypeReference)new TypeReference<List<SuggestionEvidence>>(){});
        }
        catch (JsonProcessingException e) {
            log.error((Object)e);
        }
        suggestion.getEvidences().addAll(evidences);
        return suggestion;
    }

    private Item findItem(Context context, UUID itemId) {
        try {
            return (Item)this.itemService.find(context, itemId);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private Item findItem(Context context, String itemId) {
        return this.findItem(context, UUIDUtils.fromString(itemId));
    }
}

