/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.HibernateProxyHelper;

public class SubmissionStepConfig
implements Serializable {
    public static final String INPUT_FORM_STEP_NAME = "submission-form";
    public static final String UPLOAD_STEP_NAME = "upload";
    public static final String ACCESS_CONDITION_STEP_NAME = "accessCondition";
    public static final String SELECT_COLLECTION_STEP = "collection";
    public static final String COMPLETE_STEP = "complete";
    private String id = null;
    private boolean mandatory = true;
    private String heading = null;
    private String processingClassName = null;
    private String type = null;
    private String scope = null;
    private String visibility = null;
    private String visibilityOutside = null;
    private int number = -1;

    public SubmissionStepConfig() {
    }

    public SubmissionStepConfig(Map<String, String> stepMap) {
        this.id = stepMap.get("id");
        String s = stepMap.get("mandatory");
        if (s != null) {
            this.mandatory = BooleanUtils.toBoolean((String)s);
        }
        this.heading = stepMap.get("heading");
        this.processingClassName = stepMap.get("processing-class");
        this.type = stepMap.get("type");
        this.scope = stepMap.get("scope");
        this.visibility = stepMap.get("scope.visibility");
        this.visibilityOutside = stepMap.get("scope.visibilityOutside");
    }

    public String getId() {
        return this.id;
    }

    public String getHeading() {
        return this.heading;
    }

    public String getProcessingClassName() {
        return this.processingClassName;
    }

    public String getType() {
        return this.type;
    }

    public String getScope() {
        return this.scope;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public String getVisibilityOutside() {
        return this.visibilityOutside;
    }

    public boolean isHiddenForInProgressSubmission(InProgressSubmission obj) {
        String scopeToCheck = this.getScope(obj);
        if (this.scope == null || scopeToCheck == null) {
            return false;
        }
        String visibility = this.getVisibility();
        String visibilityOutside = this.getVisibilityOutside();
        if (this.scope.equalsIgnoreCase(scopeToCheck)) {
            return "hidden".equalsIgnoreCase(visibility);
        }
        return visibilityOutside == null || "hidden".equalsIgnoreCase(visibilityOutside);
    }

    private String getScope(InProgressSubmission obj) {
        if (HibernateProxyHelper.getClassWithoutInitializingProxy(obj).equals(WorkspaceItem.class)) {
            return "submission";
        }
        return "workflow";
    }

    public int getStepNumber() {
        return this.number;
    }

    protected void setStepNumber(int stepNum) {
        this.number = stepNum;
    }

    public boolean isVisible() {
        return this.heading != null && this.heading.length() > 0;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }
}

