/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.dspace.browse.BrowseException;

public class BrowseOutput {
    private boolean verbose = false;
    private boolean print = false;
    private boolean file = false;
    private boolean append = true;
    private String fileName;

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.setAppend(false);
    }

    public boolean isFile() {
        return this.file;
    }

    public void setFile(boolean file) {
        this.file = file;
    }

    public boolean isPrint() {
        return this.print;
    }

    public void setPrint(boolean print) {
        this.print = print;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void message(String message) {
        if (this.isVerbose()) {
            System.out.println(message);
        }
    }

    public void urgent(String message) {
        System.out.println(message);
    }

    public void sql(String sql) throws BrowseException {
        if (this.isPrint()) {
            System.out.println(sql);
        }
        if (this.isFile()) {
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(this.fileName, this.isAppend()));
                out.write(sql + "\n");
                out.close();
                this.setAppend(true);
            }
            catch (IOException e) {
                throw new BrowseException(e);
            }
        }
    }
}

