/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.sql.SQLException;
import java.time.Instant;
import org.dspace.checker.BitstreamDispatcher;
import org.dspace.checker.MostRecentChecksum;
import org.dspace.checker.factory.CheckerServiceFactory;
import org.dspace.checker.service.MostRecentChecksumService;
import org.dspace.content.Bitstream;
import org.dspace.core.Context;

public class SimpleDispatcher
implements BitstreamDispatcher {
    protected boolean loopContinuously = false;
    protected Instant processStartTime = null;
    protected MostRecentChecksumService checksumService;
    protected Context context;

    public SimpleDispatcher(Context context, Instant startTime, boolean looping) {
        this.checksumService = CheckerServiceFactory.getInstance().getMostRecentChecksumService();
        this.context = context;
        this.processStartTime = startTime;
        this.loopContinuously = looping;
    }

    private SimpleDispatcher() {
    }

    @Override
    public synchronized Bitstream next() throws SQLException {
        if (!this.loopContinuously && this.processStartTime != null) {
            MostRecentChecksum oldestRecord = this.checksumService.findOldestRecord(this.context, this.processStartTime);
            if (oldestRecord != null) {
                return oldestRecord.getBitstream();
            }
            return null;
        }
        MostRecentChecksum oldestRecord = this.checksumService.findOldestRecord(this.context);
        if (oldestRecord != null) {
            return oldestRecord.getBitstream();
        }
        return null;
    }
}

