/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.text.DateFormatSymbols;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DCDate {
    private static Logger log = LogManager.getLogger(DCDate.class);
    private ZonedDateTime calendar = null;
    private ZonedDateTime localCalendar = null;
    DateGran granularity = null;
    private final DateTimeFormatter fullIso = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").withZone(ZoneOffset.UTC);
    private final DateTimeFormatter fullIso2 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss").withZone(ZoneOffset.UTC);
    private final DateTimeFormatter fullIso3 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm").withZone(ZoneOffset.UTC);
    private final DateTimeFormatter fullIso4 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH").withZone(ZoneOffset.UTC);
    private final DateTimeFormatter dateIso = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneOffset.UTC);
    private final DateTimeFormatter yearMonthIso = DateTimeFormatter.ofPattern("yyyy-MM").withZone(ZoneOffset.UTC);
    private final DateTimeFormatter yearIso = DateTimeFormatter.ofPattern("yyyy").withZone(ZoneOffset.UTC);
    private final DateTimeFormatter fullIsoWithMs = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'.000'").withZone(ZoneOffset.UTC);
    private static Map<Locale, DateFormatSymbols> dfsLocaleMap = new HashMap<Locale, DateFormatSymbols>();

    public DCDate(ZonedDateTime date) {
        if (date == null) {
            return;
        }
        this.granularity = DateGran.TIME;
        this.localCalendar = date;
        this.calendar = date.withZoneSameInstant(ZoneOffset.UTC);
    }

    public DCDate(int yyyy, int mm, int dd, int hh, int mn, int ss) {
        int lyear = 0;
        int lhours = 0;
        int lminutes = 0;
        int lseconds = 0;
        int lmonth = 1;
        int lday = 1;
        if (yyyy > 0) {
            lyear = yyyy;
            this.granularity = DateGran.YEAR;
        }
        if (mm > 0) {
            lmonth = mm;
            this.granularity = DateGran.MONTH;
        }
        if (dd > 0) {
            lday = dd;
            this.granularity = DateGran.DAY;
        }
        if (hh >= 0) {
            lhours = hh;
            this.granularity = DateGran.TIME;
        }
        if (mn >= 0) {
            lminutes = mn;
            this.granularity = DateGran.TIME;
        }
        if (ss >= 0) {
            lseconds = ss;
            this.granularity = DateGran.TIME;
        }
        this.localCalendar = ZonedDateTime.of(lyear, lmonth, lday, lhours, lminutes, lseconds, 0, ZoneId.systemDefault());
        this.calendar = this.granularity == DateGran.TIME ? this.localCalendar.withZoneSameInstant(ZoneOffset.UTC) : ZonedDateTime.of(this.localCalendar.getYear(), this.localCalendar.getMonthValue(), this.localCalendar.getDayOfMonth(), 0, 0, 0, 0, ZoneOffset.UTC);
    }

    public DCDate(String fromDC) {
        if (fromDC == null || fromDC.equals("")) {
            return;
        }
        this.granularity = DateGran.TIME;
        ZonedDateTime date = this.tryParse(this.fullIso, fromDC);
        if (date == null) {
            date = this.tryParse(this.fullIso2, fromDC);
        }
        if (date == null) {
            date = this.tryParse(this.fullIso3, fromDC);
        }
        if (date == null) {
            date = this.tryParse(this.fullIso4, fromDC);
        }
        if (date == null) {
            date = this.tryParse(this.fullIsoWithMs, fromDC);
        }
        if (date == null) {
            try {
                date = LocalDate.parse(fromDC, this.dateIso).atStartOfDay(ZoneId.systemDefault());
            }
            catch (DateTimeParseException e) {
                date = null;
            }
            if (date != null) {
                this.granularity = DateGran.DAY;
            }
        }
        if (date == null) {
            try {
                date = YearMonth.parse(fromDC, this.yearMonthIso).atDay(1).atStartOfDay(ZoneId.systemDefault());
            }
            catch (DateTimeParseException e) {
                date = null;
            }
            if (date != null) {
                this.granularity = DateGran.MONTH;
            }
        }
        if (date == null) {
            try {
                date = Year.parse(fromDC, this.yearIso).atMonth(1).atDay(1).atStartOfDay(ZoneId.systemDefault());
            }
            catch (DateTimeParseException e) {
                date = null;
            }
            if (date != null) {
                this.granularity = DateGran.YEAR;
            }
        }
        if (date == null) {
            log.warn("Mangled date: " + fromDC + "  ..failed all attempts to parse as date.");
        } else {
            this.calendar = date;
            this.localCalendar = this.granularity == DateGran.TIME ? date.withZoneSameInstant(ZoneId.systemDefault()) : ZonedDateTime.of(this.calendar.getYear(), this.calendar.getMonth().getValue(), this.calendar.getDayOfMonth(), 0, 0, 0, 0, ZoneOffset.UTC);
        }
    }

    private synchronized ZonedDateTime tryParse(DateTimeFormatter formatter, String source) {
        try {
            return ZonedDateTime.parse(source, formatter);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public int getYear() {
        return !this.withinGranularity(DateGran.YEAR) ? -1 : this.localCalendar.getYear();
    }

    public int getMonth() {
        return !this.withinGranularity(DateGran.MONTH) ? -1 : this.localCalendar.getMonthValue();
    }

    public int getDay() {
        return !this.withinGranularity(DateGran.DAY) ? -1 : this.localCalendar.getDayOfMonth();
    }

    public int getHour() {
        return !this.withinGranularity(DateGran.TIME) ? -1 : this.localCalendar.getHour();
    }

    public int getMinute() {
        return !this.withinGranularity(DateGran.TIME) ? -1 : this.localCalendar.getMinute();
    }

    public int getSecond() {
        return !this.withinGranularity(DateGran.TIME) ? -1 : this.localCalendar.getSecond();
    }

    public int getYearUTC() {
        return !this.withinGranularity(DateGran.YEAR) ? -1 : this.calendar.getYear();
    }

    public int getMonthUTC() {
        return !this.withinGranularity(DateGran.MONTH) ? -1 : this.calendar.getMonthValue();
    }

    public int getDayUTC() {
        return !this.withinGranularity(DateGran.DAY) ? -1 : this.calendar.getDayOfMonth();
    }

    public int getHourUTC() {
        return !this.withinGranularity(DateGran.TIME) ? -1 : this.calendar.getHour();
    }

    public int getMinuteUTC() {
        return !this.withinGranularity(DateGran.TIME) ? -1 : this.calendar.getMinute();
    }

    public int getSecondUTC() {
        return !this.withinGranularity(DateGran.TIME) ? -1 : this.calendar.getSecond();
    }

    public String toString() {
        if (this.calendar == null) {
            return "null";
        }
        return this.toStringInternal();
    }

    private synchronized String toStringInternal() {
        if (this.granularity == DateGran.YEAR) {
            return String.format("%4d", this.getYearUTC());
        }
        if (this.granularity == DateGran.MONTH) {
            return String.format("%4d-%02d", this.getYearUTC(), this.getMonthUTC());
        }
        if (this.granularity == DateGran.DAY) {
            return String.format("%4d-%02d-%02d", this.getYearUTC(), this.getMonthUTC(), this.getDayUTC());
        }
        return this.fullIso.format(this.calendar);
    }

    public ZonedDateTime toDate() {
        if (this.calendar == null) {
            return null;
        }
        return this.calendar;
    }

    public String displayDate(boolean showTime, boolean isLocalTime, Locale locale) {
        if (isLocalTime) {
            return this.displayLocalDate(showTime, locale);
        }
        return this.displayUTCDate(showTime, locale);
    }

    public String displayLocalDate(boolean showTime, Locale locale) {
        String monthName = DCDate.getMonthName(this.getMonth(), locale);
        if (monthName.length() > 2) {
            monthName = monthName.substring(0, 3);
        }
        if (showTime && this.granularity == DateGran.TIME) {
            return String.format("%d-%s-%4d %02d:%02d:%02d", this.getDay(), monthName, this.getYear(), this.getHour(), this.getMinute(), this.getSecond());
        }
        if (this.granularity == DateGran.YEAR) {
            return String.format("%4d", this.getYear());
        }
        if (this.granularity == DateGran.MONTH) {
            return String.format("%s-%4d", monthName, this.getYear());
        }
        return String.format("%d-%s-%4d", this.getDay(), monthName, this.getYear());
    }

    public String displayUTCDate(boolean showTime, Locale locale) {
        String monthName = DCDate.getMonthName(this.getMonthUTC(), locale);
        if (monthName.length() > 2) {
            monthName = monthName.substring(0, 3);
        }
        if (showTime && this.granularity == DateGran.TIME) {
            return String.format("%d-%s-%4d %02d:%02d:%02d", this.getDayUTC(), monthName, this.getYearUTC(), this.getHourUTC(), this.getMinuteUTC(), this.getSecondUTC());
        }
        if (this.granularity == DateGran.YEAR) {
            return String.format("%4d", this.getYearUTC());
        }
        if (this.granularity == DateGran.MONTH) {
            return String.format("%s-%4d", monthName, this.getYearUTC());
        }
        return String.format("%d-%s-%4d", this.getDayUTC(), monthName, this.getYearUTC());
    }

    private boolean withinGranularity(DateGran dg) {
        if (this.granularity == DateGran.TIME && (dg == DateGran.TIME || dg == DateGran.DAY || dg == DateGran.MONTH || dg == DateGran.YEAR)) {
            return true;
        }
        if (this.granularity == DateGran.DAY && (dg == DateGran.DAY || dg == DateGran.MONTH || dg == DateGran.YEAR)) {
            return true;
        }
        if (this.granularity == DateGran.MONTH && (dg == DateGran.MONTH || dg == DateGran.YEAR)) {
            return true;
        }
        return this.granularity == DateGran.YEAR && dg == DateGran.YEAR;
    }

    public static DCDate getCurrent() {
        return new DCDate(ZonedDateTime.now(ZoneOffset.UTC));
    }

    public static String getMonthName(int m, Locale locale) {
        if (m > 0 && m < 13) {
            DateFormatSymbols dfs = dfsLocaleMap.get(locale);
            if (dfs == null) {
                dfs = new DateFormatSymbols(locale);
                dfsLocaleMap.put(locale, dfs);
            }
            return dfs.getMonths()[m - 1];
        }
        return "Unspecified";
    }

    private static enum DateGran {
        YEAR,
        MONTH,
        DAY,
        TIME;

    }
}

