/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataFieldName;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.MetadataValueComparators;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipMetadataValue;
import org.dspace.content.authority.Choices;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.content.authority.service.MetadataAuthorityService;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataValueService;
import org.dspace.content.service.RelationshipService;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.handle.service.HandleService;
import org.dspace.identifier.service.IdentifierService;
import org.dspace.utils.DSpace;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DSpaceObjectServiceImpl<T extends DSpaceObject>
implements DSpaceObjectService<T> {
    private static final Logger log = LogManager.getLogger(DSpaceObjectServiceImpl.class);
    @Autowired(required=true)
    protected ChoiceAuthorityService choiceAuthorityService;
    @Autowired(required=true)
    protected HandleService handleService;
    @Autowired(required=true)
    protected MetadataValueService metadataValueService;
    @Autowired(required=true)
    protected MetadataFieldService metadataFieldService;
    @Autowired(required=true)
    protected MetadataAuthorityService metadataAuthorityService;
    @Autowired(required=true)
    protected RelationshipService relationshipService;

    @Override
    public String getName(T dso) {
        String value = this.getMetadataFirstValue(dso, MetadataSchemaEnum.DC.getName(), "title", null, "*");
        return value == null ? "" : value;
    }

    @Override
    public ArrayList<String> getIdentifiers(Context context, T dso) {
        ArrayList<String> identifiers = new ArrayList<String>();
        IdentifierService identifierService = (IdentifierService)new DSpace().getSingletonService(IdentifierService.class);
        if (identifierService != null) {
            identifiers.addAll(identifierService.lookup(context, (DSpaceObject)dso));
        } else {
            log.warn("No IdentifierService found, will return an list containing the Handle only.");
            if (((DSpaceObject)dso).getHandle() != null) {
                identifiers.add(this.handleService.getCanonicalForm(((DSpaceObject)dso).getHandle()));
            }
        }
        return identifiers;
    }

    @Override
    public DSpaceObject getParentObject(Context context, T dso) throws SQLException {
        return null;
    }

    @Override
    public DSpaceObject getAdminObject(Context context, T dso, int action) throws SQLException {
        if (action == 11) {
            throw new IllegalArgumentException("Illegal call to the DSpaceObject.getAdminObject method");
        }
        return dso;
    }

    @Override
    public String getTypeText(T dso) {
        return Constants.typeText[((DSpaceObject)dso).getType()];
    }

    @Override
    public List<MetadataValue> getMetadata(T dso, String schema, String element, String qualifier, String lang) {
        ArrayList<MetadataValue> values = new ArrayList<MetadataValue>();
        for (MetadataValue dcv : ((DSpaceObject)dso).getMetadata()) {
            if (!this.match(schema, element, qualifier, lang, dcv)) continue;
            values.add(dcv);
        }
        if (((DSpaceObject)dso).isMetadataModified()) {
            values.sort(MetadataValueComparators.defaultComparator);
        }
        return values;
    }

    @Override
    public List<MetadataValue> getMetadataByMetadataString(T dso, String mdString) {
        StringTokenizer dcf = new StringTokenizer(mdString, ".");
        String[] tokens = new String[]{"", "", ""};
        int i = 0;
        while (dcf.hasMoreTokens()) {
            tokens[i] = dcf.nextToken().trim();
            ++i;
        }
        String schema = tokens[0];
        String element = tokens[1];
        String qualifier = tokens[2];
        List<MetadataValue> values = this.getMetadata(dso, schema, element, qualifier);
        return values;
    }

    private List<MetadataValue> getMetadata(T dso, String schema, String element, String qualifier) {
        List<MetadataValue> values = "*".equals(qualifier) ? this.getMetadata(dso, schema, element, "*", "*") : ("".equals(qualifier) ? this.getMetadata(dso, schema, element, null, "*") : this.getMetadata(dso, schema, element, qualifier, "*"));
        return values;
    }

    @Override
    public String getMetadata(T dso, String value) {
        List<MetadataValue> metadataValues = this.getMetadataByMetadataString(dso, value);
        if (CollectionUtils.isNotEmpty(metadataValues)) {
            return metadataValues.iterator().next().getValue();
        }
        return null;
    }

    @Override
    public List<MetadataValue> getMetadata(T dso, String mdString, String authority) {
        String[] elements = this.getElements(mdString);
        return this.getMetadata(dso, elements[0], elements[1], elements[2], elements[3], authority);
    }

    @Override
    public List<MetadataValue> getMetadata(T dso, String schema, String element, String qualifier, String lang, String authority) {
        List<MetadataValue> metadata = this.getMetadata(dso, schema, element, qualifier, lang);
        ArrayList<MetadataValue> result = new ArrayList<MetadataValue>(metadata);
        if (!authority.equals("*")) {
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                MetadataValue metadataValue = (MetadataValue)iterator.next();
                if (authority.equals(metadataValue.getAuthority())) continue;
                iterator.remove();
            }
        }
        return result;
    }

    @Override
    public List<MetadataValue> addMetadata(Context context, T dso, String schema, String element, String qualifier, String lang, List<String> values) throws SQLException {
        MetadataField metadataField = this.metadataFieldService.findByElement(context, schema, element, qualifier);
        if (metadataField == null) {
            throw new SQLException("bad_dublin_core schema=" + schema + "." + element + "." + qualifier + ". Metadata field does not exist!");
        }
        return this.addMetadata(context, dso, metadataField, lang, values);
    }

    @Override
    public List<MetadataValue> addMetadata(Context context, T dso, String schema, String element, String qualifier, String lang, List<String> values, List<String> authorities, List<Integer> confidences) throws SQLException {
        MetadataField metadataField = this.metadataFieldService.findByElement(context, schema, element, qualifier);
        if (metadataField == null) {
            throw new SQLException("bad_dublin_core schema=" + schema + "." + element + "." + qualifier + ". Metadata field does not exist!");
        }
        return this.addMetadata(context, dso, metadataField, lang, values, authorities, confidences);
    }

    @Override
    public List<MetadataValue> addMetadata(Context context, T dso, MetadataField metadataField, String lang, List<String> values, List<String> authorities, List<Integer> confidences) throws SQLException {
        Supplier<Integer> placeSupplier = () -> this.getMetadata(dso, metadataField.getMetadataSchema().getName(), metadataField.getElement(), metadataField.getQualifier(), "*").size() - 1;
        return this.addMetadata(context, dso, metadataField, lang, values, authorities, confidences, placeSupplier);
    }

    public List<MetadataValue> addMetadata(Context context, T dso, MetadataField metadataField, String lang, List<String> values, List<String> authorities, List<Integer> confidences, Supplier<Integer> placeSupplier) throws SQLException {
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException("Cannot add empty values to a new metadata field " + metadataField.toString() + " on object with uuid = " + ((DSpaceObject)dso).getID().toString() + " and type = " + this.getTypeText(dso));
        }
        boolean authorityControlled = this.metadataAuthorityService.isAuthorityControlled(metadataField);
        boolean authorityRequired = this.metadataAuthorityService.isAuthorityRequired(metadataField);
        ArrayList<MetadataValue> newMetadata = new ArrayList<MetadataValue>();
        for (int i = 0; i < values.size(); ++i) {
            if (values.get(i) == null || authorities != null && authorities.size() >= i && StringUtils.startsWith((CharSequence)authorities.get(i), (CharSequence)"virtual::")) continue;
            MetadataValue metadataValue = this.metadataValueService.create(context, (DSpaceObject)dso, metadataField);
            newMetadata.add(metadataValue);
            metadataValue.setPlace(placeSupplier.get());
            metadataValue.setLanguage(lang == null ? null : lang.trim());
            if (authorityControlled) {
                if (authorities != null && authorities.get(i) != null && authorities.get(i).length() > 0) {
                    metadataValue.setAuthority(authorities.get(i));
                    metadataValue.setConfidence(confidences == null ? 0 : confidences.get(i));
                } else {
                    metadataValue.setAuthority(null);
                    metadataValue.setConfidence(confidences == null ? -1 : confidences.get(i));
                }
                if (authorityRequired && (metadataValue.getAuthority() == null || metadataValue.getAuthority().length() == 0)) {
                    throw new IllegalArgumentException("The metadata field \"" + metadataField.toString() + "\" requires an authority key but none was provided. Value=\"" + values.get(i) + "\"");
                }
            }
            String temp = values.get(i).trim();
            char[] dcvalue = temp.toCharArray();
            for (int charPos = 0; charPos < dcvalue.length; ++charPos) {
                if (!Character.isISOControl(dcvalue[charPos]) || String.valueOf(dcvalue[charPos]).equals("\t") || String.valueOf(dcvalue[charPos]).equals("\n") || String.valueOf(dcvalue[charPos]).equals("\r")) continue;
                dcvalue[charPos] = 32;
            }
            metadataValue.setValue(String.valueOf(dcvalue));
            ((DSpaceObject)dso).addDetails(metadataField.toString());
        }
        this.setMetadataModified(dso);
        return newMetadata;
    }

    @Override
    public MetadataValue addMetadata(Context context, T dso, MetadataField metadataField, String language, String value, String authority, int confidence) throws SQLException {
        List<MetadataValue> metadataValues = this.addMetadata(context, dso, metadataField, language, Arrays.asList(value), Arrays.asList(authority), Arrays.asList(confidence));
        return CollectionUtils.isNotEmpty(metadataValues) ? metadataValues.get(0) : null;
    }

    @Override
    public MetadataValue addMetadata(Context context, T dso, String schema, String element, String qualifier, String lang, String value) throws SQLException {
        List<MetadataValue> metadataValues = this.addMetadata(context, dso, schema, element, qualifier, lang, Arrays.asList(value));
        return CollectionUtils.isNotEmpty(metadataValues) ? metadataValues.get(0) : null;
    }

    @Override
    public MetadataValue addMetadata(Context context, T dso, MetadataField metadataField, String language, String value) throws SQLException {
        List<MetadataValue> metadataValues = this.addMetadata(context, dso, metadataField, language, Arrays.asList(value));
        return CollectionUtils.isNotEmpty(metadataValues) ? metadataValues.get(0) : null;
    }

    @Override
    public List<MetadataValue> addMetadata(Context context, T dso, MetadataField metadataField, String language, List<String> values) throws SQLException {
        if (metadataField != null) {
            String fieldKey = this.metadataAuthorityService.makeFieldKey(metadataField.getMetadataSchema().getName(), metadataField.getElement(), metadataField.getQualifier());
            if (this.metadataAuthorityService.isAuthorityControlled(fieldKey)) {
                ArrayList<String> authorities = new ArrayList<String>();
                ArrayList<Integer> confidences = new ArrayList<Integer>();
                for (int i = 0; i < values.size(); ++i) {
                    if (dso instanceof Item) {
                        this.getAuthoritiesAndConfidences(fieldKey, ((Item)dso).getOwningCollection(), values, authorities, confidences, i);
                        continue;
                    }
                    this.getAuthoritiesAndConfidences(fieldKey, null, values, authorities, confidences, i);
                }
                return this.addMetadata(context, dso, metadataField, language, values, authorities, confidences);
            }
            return this.addMetadata(context, dso, metadataField, language, values, null, null);
        }
        return new ArrayList<MetadataValue>(0);
    }

    @Override
    public MetadataValue addMetadata(Context context, T dso, String schema, String element, String qualifier, String lang, String value, String authority, int confidence) throws SQLException {
        return this.addMetadata(context, dso, schema, element, qualifier, lang, Arrays.asList(value), Arrays.asList(authority), Arrays.asList(confidence)).stream().findFirst().orElse(null);
    }

    @Override
    public void clearMetadata(Context context, T dso, String schema, String element, String qualifier, String lang) throws SQLException {
        Iterator<MetadataValue> metadata = ((DSpaceObject)dso).getMetadata().iterator();
        while (metadata.hasNext()) {
            MetadataValue metadataValue = metadata.next();
            if (!this.match(schema, element, qualifier, lang, metadataValue)) continue;
            metadata.remove();
            this.metadataValueService.delete(context, metadataValue);
        }
        ((DSpaceObject)dso).setMetadataModified();
    }

    @Override
    public void removeMetadataValues(Context context, T dso, List<MetadataValue> values) throws SQLException {
        Iterator<MetadataValue> metadata = ((DSpaceObject)dso).getMetadata().iterator();
        while (metadata.hasNext()) {
            MetadataValue metadataValue = metadata.next();
            if (!values.contains(metadataValue)) continue;
            metadata.remove();
            this.metadataValueService.delete(context, metadataValue);
        }
        ((DSpaceObject)dso).setMetadataModified();
    }

    @Override
    public String getMetadataFirstValue(T dso, String schema, String element, String qualifier, String language) {
        List<MetadataValue> metadataValues = this.getMetadata(dso, schema, element, qualifier, language);
        if (CollectionUtils.isNotEmpty(metadataValues)) {
            return metadataValues.iterator().next().getValue();
        }
        return null;
    }

    @Override
    public String getMetadataFirstValue(T dso, MetadataFieldName field, String language) {
        List<MetadataValue> metadataValues = this.getMetadata(dso, field.schema, field.element, field.qualifier, language);
        if (CollectionUtils.isNotEmpty(metadataValues)) {
            return metadataValues.get(0).getValue();
        }
        return null;
    }

    @Override
    public void setMetadataSingleValue(Context context, T dso, String schema, String element, String qualifier, String language, String value) throws SQLException {
        if (value != null) {
            this.clearMetadata(context, dso, schema, element, qualifier, language);
            this.addMetadata(context, dso, schema, element, qualifier, language, value);
            ((DSpaceObject)dso).setMetadataModified();
        }
    }

    @Override
    public void setMetadataSingleValue(Context context, T dso, MetadataFieldName field, String language, String value) throws SQLException {
        if (value != null) {
            this.clearMetadata(context, dso, field.schema, field.element, field.qualifier, language);
            String newValueLanguage = "*".equals(language) ? null : language;
            this.addMetadata(context, dso, field.schema, field.element, field.qualifier, newValueLanguage, value);
            ((DSpaceObject)dso).setMetadataModified();
        }
    }

    protected boolean match(String schema, String element, String qualifier, String language, MetadataValue metadataValue) {
        MetadataField metadataField = metadataValue.getMetadataField();
        MetadataSchema metadataSchema = metadataField.getMetadataSchema();
        if (!element.equals("*") && !element.equals(metadataField.getElement())) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)qualifier) ? metadataField.getQualifier() != null : !qualifier.equals("*") && !qualifier.equals(metadataField.getQualifier())) {
            return false;
        }
        if (language == null ? metadataValue.getLanguage() != null : !language.equals("*") && !language.equals(metadataValue.getLanguage())) {
            return false;
        }
        return schema.equals("*") || metadataSchema == null || metadataSchema.getName().equals(schema);
    }

    protected void getAuthoritiesAndConfidences(String fieldKey, Collection collection, List<String> values, List<String> authorities, List<Integer> confidences, int i) {
        Choices c = this.choiceAuthorityService.getBestMatch(fieldKey, values.get(i), collection, null);
        authorities.add(c.values.length > 0 ? c.values[0].authority : null);
        confidences.add(c.confidence);
    }

    protected String[] getElements(String fieldName) {
        Object[] tokens = StringUtils.split((String)fieldName, (String)".");
        int add = 4 - tokens.length;
        if (add > 0) {
            tokens = (String[])ArrayUtils.addAll((Object[])tokens, (Object[])new String[add]);
        }
        return tokens;
    }

    protected String[] getElementsFilled(String fieldName) {
        String[] elements = this.getElements(fieldName);
        for (int i = 0; i < elements.length; ++i) {
            if (!StringUtils.isBlank((CharSequence)elements[i])) continue;
            elements[i] = "*";
        }
        return elements;
    }

    protected String[] getMDValueByField(String field) {
        StringTokenizer dcf = new StringTokenizer(field, ".");
        String[] tokens = new String[]{"", "", ""};
        int i = 0;
        while (dcf.hasMoreTokens()) {
            tokens[i] = dcf.nextToken().trim();
            ++i;
        }
        if (i != 0) {
            return tokens;
        }
        return this.getMDValueByLegacyField(field);
    }

    @Override
    public void update(Context context, T dso) throws SQLException, AuthorizeException {
        if (((DSpaceObject)dso).isMetadataModified()) {
            HashMap<MetadataField, Integer> fieldToLastPlace = new HashMap<MetadataField, Integer>();
            List<MetadataValue> metadataValues = ((DSpaceObject)dso).getType() == 2 ? this.getMetadata(dso, "*", "*", "*", "*") : ((DSpaceObject)dso).getMetadata();
            metadataValues.sort((o1, o2) -> {
                int compare = o1.getPlace() - o2.getPlace();
                if (compare == 0) {
                    if (o1 instanceof RelationshipMetadataValue && o2 instanceof RelationshipMetadataValue) {
                        return compare;
                    }
                    if (o1 instanceof RelationshipMetadataValue) {
                        return 1;
                    }
                    if (o2 instanceof RelationshipMetadataValue) {
                        return -1;
                    }
                }
                return compare;
            });
            for (MetadataValue metadataValue : metadataValues) {
                int mvPlace;
                if (StringUtils.startsWith((CharSequence)metadataValue.getAuthority(), (CharSequence)"virtual::") && metadataValue instanceof RelationshipMetadataValue && ((RelationshipMetadataValue)metadataValue).isUseForPlace()) {
                    mvPlace = this.getMetadataValuePlace(fieldToLastPlace, metadataValue);
                    metadataValue.setPlace(mvPlace);
                    String authority = metadataValue.getAuthority();
                    String relationshipId = StringUtils.split((String)authority, (String)"::")[1];
                    Relationship relationship = (Relationship)this.relationshipService.find(context, Integer.parseInt(relationshipId));
                    if (relationship.getLeftItem().equals(dso)) {
                        relationship.setLeftPlace(mvPlace);
                    } else {
                        relationship.setRightPlace(mvPlace);
                    }
                    this.relationshipService.update(context, relationship);
                    continue;
                }
                if (StringUtils.equals((CharSequence)metadataValue.getMetadataField().getMetadataSchema().getName(), (CharSequence)"relation")) continue;
                mvPlace = this.getMetadataValuePlace(fieldToLastPlace, metadataValue);
                metadataValue.setPlace(mvPlace);
            }
        }
    }

    protected int getMetadataValuePlace(Map<MetadataField, Integer> fieldToLastPlace, MetadataValue metadataValue) {
        MetadataField metadataField = metadataValue.getMetadataField();
        if (fieldToLastPlace.containsKey(metadataField)) {
            fieldToLastPlace.put(metadataField, fieldToLastPlace.get(metadataField) + 1);
        } else {
            fieldToLastPlace.put(metadataField, 0);
        }
        return fieldToLastPlace.get(metadataField);
    }

    protected String[] getMDValueByLegacyField(String field) {
        switch (field) {
            case "introductory_text": {
                return new String[]{MetadataSchemaEnum.DC.getName(), "description", null};
            }
            case "short_description": {
                return new String[]{MetadataSchemaEnum.DC.getName(), "description", "abstract"};
            }
            case "side_bar_text": {
                return new String[]{MetadataSchemaEnum.DC.getName(), "description", "tableofcontents"};
            }
            case "copyright_text": {
                return new String[]{MetadataSchemaEnum.DC.getName(), "rights", null};
            }
            case "name": {
                return new String[]{MetadataSchemaEnum.DC.getName(), "title", null};
            }
            case "provenance_description": {
                return new String[]{MetadataSchemaEnum.DC.getName(), "provenance", null};
            }
            case "license": {
                return new String[]{MetadataSchemaEnum.DC.getName(), "rights", "license"};
            }
            case "user_format_description": {
                return new String[]{MetadataSchemaEnum.DC.getName(), "format", null};
            }
            case "source": {
                return new String[]{MetadataSchemaEnum.DC.getName(), "source", null};
            }
            case "firstname": {
                return new String[]{"eperson", "firstname", null};
            }
            case "lastname": {
                return new String[]{"eperson", "lastname", null};
            }
            case "phone": {
                return new String[]{"eperson", "phone", null};
            }
            case "language": {
                return new String[]{"eperson", "language", null};
            }
        }
        return new String[]{null, null, null};
    }

    @Override
    public void addAndShiftRightMetadata(Context context, T dso, String schema, String element, String qualifier, String lang, String value, String authority, int confidence, int index) throws SQLException {
        List<MetadataValue> list = this.getMetadata(dso, schema, element, qualifier);
        int idx = 0;
        int place = 0;
        boolean last = true;
        for (MetadataValue rr : list) {
            if (idx == index) {
                MetadataValue newMetadata = this.addMetadata(context, dso, schema, element, qualifier, lang, value, authority, confidence);
                this.moveSingleMetadataValue(context, dso, place, newMetadata);
                ++place;
                last = false;
            }
            this.moveSingleMetadataValue(context, dso, place, rr);
            ++place;
            ++idx;
        }
        if (last) {
            this.addMetadata(context, dso, schema, element, qualifier, lang, value, authority, confidence);
        }
    }

    @Override
    public void moveMetadata(Context context, T dso, String schema, String element, String qualifier, int from, int to) throws SQLException, IllegalArgumentException {
        if (from == to) {
            throw new IllegalArgumentException("The \"from\" location MUST be different from \"to\" location");
        }
        List list = this.getMetadata(dso, schema, element, qualifier).stream().sorted(Comparator.comparing(MetadataValue::getPlace)).collect(Collectors.toList());
        if (from >= list.size() || to >= list.size() || to < 0 || from < 0) {
            throw new IllegalArgumentException("The \"from\" and \"to\" locations MUST exist for the operation to be successful.\n To and from indices must be between 0 and " + (list.size() - 1) + "\n Idx from:" + from + " Idx to: " + to);
        }
        int idx = 0;
        MetadataValue moved = null;
        for (MetadataValue md : list) {
            if (idx == from) {
                moved = md;
                break;
            }
            ++idx;
        }
        idx = 0;
        int place = 0;
        boolean last = true;
        for (MetadataValue rr : list) {
            if (idx == to && to < from) {
                this.moveSingleMetadataValue(context, dso, place, moved);
                ++place;
                last = false;
            }
            if (idx != from) {
                this.moveSingleMetadataValue(context, dso, place, rr);
                ++place;
            }
            if (idx == to && to > from) {
                this.moveSingleMetadataValue(context, dso, place, moved);
                ++place;
                last = false;
            }
            ++idx;
        }
        if (last) {
            this.moveSingleMetadataValue(context, dso, place, moved);
        }
    }

    protected void moveSingleMetadataValue(Context context, T dso, int place, MetadataValue rr) {
        rr.setPlace(place);
    }

    @Override
    public void replaceMetadata(Context context, T dso, String schema, String element, String qualifier, String lang, String value, String authority, int confidence, int index) throws SQLException {
        List<MetadataValue> list = this.getMetadata(dso, schema, element, qualifier);
        this.removeMetadataValues(context, dso, Arrays.asList(list.get(index)));
        this.addAndShiftRightMetadata(context, dso, schema, element, qualifier, lang, value, authority, confidence, index);
    }

    @Override
    public void setMetadataModified(T dso) {
        ((DSpaceObject)dso).setMetadataModified();
    }

    @Override
    public MetadataValue addMetadata(Context context, T dso, String schema, String element, String qualifier, String lang, String value, String authority, int confidence, int place) throws SQLException {
        throw new NotImplementedException();
    }
}

