/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.contentreport;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.util.Arrays;
import org.apache.commons.lang3.function.TriFunction;
import org.dspace.content.MetadataValue;
import org.dspace.util.JpaCriteriaBuilderKit;

public enum QueryOperator {
    EXISTS("exists", true, false, (TriFunction<String, String, JpaCriteriaBuilderKit<MetadataValue>, Predicate>)((TriFunction)(val, regexClause, jpaKit) -> jpaKit.criteriaBuilder().isNotNull((Expression)jpaKit.root().get("value")))),
    DOES_NOT_EXIST("doesnt_exist", true, true, (TriFunction<String, String, JpaCriteriaBuilderKit<MetadataValue>, Predicate>)((TriFunction)(val, regexClause, jpaKit) -> EXISTS.buildJpaPredicate((String)val, (String)regexClause, (JpaCriteriaBuilderKit<MetadataValue>)jpaKit))),
    EQUALS("equals", true, false, (TriFunction<String, String, JpaCriteriaBuilderKit<MetadataValue>, Predicate>)((TriFunction)(val, regexClause, jpaKit) -> jpaKit.criteriaBuilder().equal((Expression)jpaKit.root().get("value"), val))),
    DOES_NOT_EQUAL("not_equals", true, true, (TriFunction<String, String, JpaCriteriaBuilderKit<MetadataValue>, Predicate>)((TriFunction)(val, regexClause, jpaKit) -> EQUALS.buildJpaPredicate((String)val, (String)regexClause, (JpaCriteriaBuilderKit<MetadataValue>)jpaKit))),
    LIKE("like", true, false, (TriFunction<String, String, JpaCriteriaBuilderKit<MetadataValue>, Predicate>)((TriFunction)(val, regexClause, jpaKit) -> jpaKit.criteriaBuilder().like((Expression)jpaKit.root().get("value"), val))),
    NOT_LIKE("not_like", true, true, (TriFunction<String, String, JpaCriteriaBuilderKit<MetadataValue>, Predicate>)((TriFunction)(val, regexClause, jpaKit) -> LIKE.buildJpaPredicate((String)val, (String)regexClause, (JpaCriteriaBuilderKit<MetadataValue>)jpaKit))),
    CONTAINS("contains", true, false, (TriFunction<String, String, JpaCriteriaBuilderKit<MetadataValue>, Predicate>)((TriFunction)(val, regexClause, jpaKit) -> LIKE.buildJpaPredicate("%" + val + "%", (String)regexClause, (JpaCriteriaBuilderKit<MetadataValue>)jpaKit))),
    DOES_NOT_CONTAIN("doesnt_contain", true, true, (TriFunction<String, String, JpaCriteriaBuilderKit<MetadataValue>, Predicate>)((TriFunction)(val, regexClause, jpaKit) -> CONTAINS.buildJpaPredicate((String)val, (String)regexClause, (JpaCriteriaBuilderKit<MetadataValue>)jpaKit))),
    MATCHES("matches", false, false, (TriFunction<String, String, JpaCriteriaBuilderKit<MetadataValue>, Predicate>)((TriFunction)(val, regexClause, jpaKit) -> QueryOperator.regexPredicate(val, "matches", jpaKit))),
    DOES_NOT_MATCH("doesnt_match", false, false, (TriFunction<String, String, JpaCriteriaBuilderKit<MetadataValue>, Predicate>)((TriFunction)(val, regexClause, jpaKit) -> QueryOperator.regexPredicate(val, "not_matches", jpaKit)));

    private final String code;
    private final TriFunction<String, String, JpaCriteriaBuilderKit<MetadataValue>, Predicate> predicateBuilder;
    private final boolean usesRegex;
    private final boolean negate;

    private QueryOperator(String code, boolean usesRegex, boolean negate, TriFunction<String, String, JpaCriteriaBuilderKit<MetadataValue>, Predicate> predicateBuilder) {
        this.code = code;
        this.usesRegex = usesRegex;
        this.negate = negate;
        this.predicateBuilder = predicateBuilder;
    }

    @JsonProperty
    public String getCode() {
        return this.code;
    }

    public boolean getUsesRegex() {
        return this.usesRegex;
    }

    public boolean getNegate() {
        return this.negate;
    }

    public Predicate buildJpaPredicate(String val, String regexClause, JpaCriteriaBuilderKit<MetadataValue> jpaKit) {
        return (Predicate)this.predicateBuilder.apply((Object)val, (Object)regexClause, jpaKit);
    }

    @JsonCreator
    public static QueryOperator get(String code) {
        return Arrays.stream(QueryOperator.values()).filter(item -> item.code.equalsIgnoreCase(code)).findFirst().orElse(null);
    }

    private static Predicate regexPredicate(String val, String regexFunction, JpaCriteriaBuilderKit<MetadataValue> jpaKit) {
        CriteriaBuilder builder = jpaKit.criteriaBuilder();
        Expression patternExpression = builder.literal((Object)val);
        Path path = jpaKit.root().get("value");
        return builder.equal(builder.function(regexFunction, Boolean.class, new Expression[]{path, patternExpression}), (Object)Boolean.TRUE);
    }
}

