/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.event;

import java.io.PrintStream;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class TestConsumer
implements Consumer {
    private static final Logger log = LogManager.getLogger(TestConsumer.class);
    private static final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private static final PrintStream out = configurationService.getBooleanProperty("testConsumer.verbose") ? System.out : null;

    @Override
    public void initialize() throws Exception {
        log.info("EVENT: called TestConsumer.initialize();");
        if (out != null) {
            out.println("TestConsumer.initialize();");
        }
    }

    @Override
    public void consume(Context ctx, Event event) throws Exception {
        EPerson ep = ctx.getCurrentUser();
        String user = ep == null ? "(none)" : ep.getEmail();
        String detail = event.getDetail();
        String msg = "EVENT: called TestConsumer.consume(): EventType=" + event.getEventTypeAsString() + ", SubjectType=" + event.getSubjectTypeAsString() + ", SubjectID=" + String.valueOf(event.getSubjectID()) + ", ObjectType=" + event.getObjectTypeAsString() + ", ObjectID=" + String.valueOf(event.getObjectID()) + ", Identifiers=" + ArrayUtils.toString(event.getIdentifiers()) + ", TimeStamp=" + DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(event.getTimeStamp())) + ", user=\"" + user + "\", extraLog=\"" + ctx.getExtraLogInfo() + "\", dispatcher=" + String.valueOf(event.getDispatcher()) + ", detail=" + (String)(detail == null ? "[null]" : "\"" + detail + "\"") + ", transactionID=" + (String)(event.getTransactionID() == null ? "[null]" : "\"" + event.getTransactionID() + "\"") + ", context=" + ctx.toString();
        log.info(msg);
        if (out != null) {
            out.println("TestConsumer.consume(): " + msg);
        }
    }

    @Override
    public void end(Context ctx) throws Exception {
        log.info("EVENT: called TestConsumer.end();");
        if (out != null) {
            out.println("TestConsumer.end();");
        }
    }

    @Override
    public void finish(Context ctx) throws Exception {
        log.info("EVENT: called TestConsumer.finish();");
        if (out != null) {
            out.println("TestConsumer.finish();");
        }
    }
}

