/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.google.client;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.dspace.google.GoogleAnalyticsEvent;
import org.dspace.google.client.GoogleAnalyticsClientRequestBuilder;

public class UniversalAnalyticsClientRequestBuilder
implements GoogleAnalyticsClientRequestBuilder {
    private final String endpointUrl;

    public UniversalAnalyticsClientRequestBuilder(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    @Override
    public String getEndpointUrl(String analyticsKey) {
        return this.endpointUrl;
    }

    @Override
    public List<String> composeRequestsBody(String analyticsKey, List<GoogleAnalyticsEvent> events) {
        if (!StringUtils.startsWith((String)analyticsKey, (String)"UA-")) {
            throw new IllegalArgumentException("Only keys with UA- prefix are supported");
        }
        String requestBody = events.stream().map(event -> this.formatEvent(analyticsKey, (GoogleAnalyticsEvent)event)).collect(Collectors.joining("\n"));
        return org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)requestBody) ? List.of(requestBody) : List.of();
    }

    private String formatEvent(String analyticsKey, GoogleAnalyticsEvent event) {
        return "v=1&tid=" + analyticsKey + "&cid=" + event.getClientId() + "&t=event&uip=" + this.encodeParameter(event.getUserIp()) + "&ua=" + this.encodeParameter(event.getUserAgent()) + "&dr=" + this.encodeParameter(event.getDocumentReferrer()) + "&dp=" + this.encodeParameter(event.getDocumentPath()) + "&dt=" + this.encodeParameter(event.getDocumentTitle()) + "&qt=" + (Instant.now().toEpochMilli() - event.getTime()) + "&ec=bitstream&ea=download&el=item";
    }

    private String encodeParameter(String parameter) {
        return URLEncoder.encode(parameter, StandardCharsets.UTF_8);
    }
}

