/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.iiif.consumer;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.iiif.consumer.CacheEvictBeanLocator;
import org.dspace.iiif.consumer.CanvasCacheEvictService;
import org.dspace.iiif.consumer.ManifestsCacheEvictService;

public class IIIFCacheEventConsumer
implements Consumer {
    private static final Logger log = LogManager.getLogger(IIIFCacheEventConsumer.class);
    private boolean clearAll = false;
    private final Set<DSpaceObject> toEvictFromManifestCache = new HashSet<DSpaceObject>();
    private final Set<DSpaceObject> toEvictFromCanvasCache = new HashSet<DSpaceObject>();

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public void consume(Context ctx, Event event) throws Exception {
        int st = event.getSubjectType();
        if (st != 1 && st != 2 && st != 0) {
            return;
        }
        DSpaceObject subject = event.getSubject(ctx);
        DSpaceObject unmodifiedSubject = event.getSubject(ctx);
        int et = event.getEventType();
        if (et == 32 || et == 16) {
            log.warn("IIIF event consumer cannot remove a single item from the cache when a bundle is deleted. The entire cache will be cleared.");
            this.clearAll = true;
        }
        if (st == 1) {
            if ((et == 8 || et == 2 || et == 4 || et == 16 || et == 32) && subject != null) {
                subject = ((Bundle)subject).getItems().get(0);
                if (log.isDebugEnabled()) {
                    log.debug("Transforming Bundle event into Item event for " + subject.getID());
                }
            } else {
                return;
            }
        }
        if (st == 0) {
            if (et == 32 || et == 16) {
                log.warn("IIIF event consumer cannot remove a single item from the cache when a bitstream is deleted. The entire cache will be cleared.");
                this.clearAll = true;
            }
            if ((et == 8 || et == 4) && subject != null && ((Bitstream)subject).getBundles().size() > 0) {
                Bundle bundle = ((Bitstream)subject).getBundles().get(0);
                subject = bundle.getItems().get(0);
                if (log.isDebugEnabled()) {
                    log.debug("Transforming Bitstream event into Item event for " + subject.getID());
                }
            } else {
                return;
            }
        }
        if (st == 2 && et == 8) {
            return;
        }
        switch (et) {
            case 8: {
                this.addToCacheEviction(subject, unmodifiedSubject, st);
                break;
            }
            case 2: {
                this.addToCacheEviction(subject, unmodifiedSubject, st);
                break;
            }
            case 4: {
                this.addToCacheEviction(subject, unmodifiedSubject, st);
                break;
            }
            case 16: {
                this.addToCacheEviction(subject, unmodifiedSubject, st);
                break;
            }
            case 32: {
                this.addToCacheEviction(subject, unmodifiedSubject, st);
                break;
            }
            default: {
                log.warn("ManifestsCacheEventConsumer should not have been given this kind of subject in an event, skipping: " + event);
            }
        }
    }

    private void addToCacheEviction(DSpaceObject subject, DSpaceObject subject2, int type) {
        if (type == 0) {
            this.toEvictFromCanvasCache.add(subject2);
        }
        this.toEvictFromManifestCache.add(subject);
    }

    @Override
    public void end(Context ctx) throws Exception {
        UUID uuid;
        ManifestsCacheEvictService manifestsCacheEvictService = CacheEvictBeanLocator.getManifestsCacheEvictService();
        CanvasCacheEvictService canvasCacheEvictService = CacheEvictBeanLocator.getCanvasCacheEvictService();
        if (manifestsCacheEvictService != null) {
            if (this.clearAll) {
                manifestsCacheEvictService.evictAllCacheValues();
            } else {
                for (DSpaceObject dso : this.toEvictFromManifestCache) {
                    uuid = dso.getID();
                    manifestsCacheEvictService.evictSingleCacheValue(uuid.toString());
                }
            }
        }
        if (canvasCacheEvictService != null) {
            for (DSpaceObject dso : this.toEvictFromCanvasCache) {
                uuid = dso.getID();
                canvasCacheEvictService.evictSingleCacheValue(uuid.toString());
            }
        }
        this.clearAll = false;
        this.toEvictFromManifestCache.clear();
        this.toEvictFromCanvasCache.clear();
    }

    @Override
    public void finish(Context ctx) throws Exception {
    }
}

