/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.liveimportclient.service;

import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.importer.external.liveimportclient.service.LiveImportClient;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class LiveImportClientImpl
implements LiveImportClient {
    private static final Logger log = LogManager.getLogger();
    public static final String URI_PARAMETERS = "uriParameters";
    public static final String HEADER_PARAMETERS = "headerParameters";
    private CloseableHttpClient httpClient;
    @Autowired
    private ConfigurationService configurationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String executeHttpGetRequest(int timeout, String URL2, Map<String, Map<String, String>> params) {
        block17: {
            HttpGet method = null;
            try {
                String string;
                block16: {
                    CloseableHttpClient httpClient = Optional.ofNullable(this.httpClient).orElseGet(HttpClients::createDefault);
                    try {
                        CloseableHttpResponse httpResponse;
                        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
                        requestConfigBuilder.setConnectionRequestTimeout(timeout);
                        RequestConfig defaultRequestConfig = requestConfigBuilder.build();
                        String uri = this.buildUrl(URL2, params.get(URI_PARAMETERS));
                        method = new HttpGet(uri);
                        method.setConfig(defaultRequestConfig);
                        Map<String, String> headerParams = params.get(HEADER_PARAMETERS);
                        if (MapUtils.isNotEmpty(headerParams)) {
                            for (String param : headerParams.keySet()) {
                                method.setHeader(param, headerParams.get(param));
                            }
                        }
                        this.configureProxy((HttpRequestBase)method, defaultRequestConfig);
                        if (log.isDebugEnabled()) {
                            log.debug("Performing GET request to \"" + uri + "\"...");
                        }
                        if (this.isNotSuccessfull((HttpResponse)(httpResponse = httpClient.execute((HttpUriRequest)method)))) {
                            throw new RuntimeException("The request failed with: " + this.getStatusCode((HttpResponse)httpResponse) + " code, reason= " + httpResponse.getStatusLine().getReasonPhrase());
                        }
                        InputStream inputStream = httpResponse.getEntity().getContent();
                        string = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
                        if (httpClient == null) break block16;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (httpClient != null) {
                                try {
                                    httpClient.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e1) {
                            log.error(e1.getMessage(), (Throwable)e1);
                            break block17;
                        }
                    }
                    httpClient.close();
                }
                return string;
            }
            finally {
                if (Objects.nonNull(method)) {
                    method.releaseConnection();
                }
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String executeHttpPostRequest(String URL2, Map<String, Map<String, String>> params, String entry) {
        block16: {
            HttpPost method = null;
            try {
                String string;
                block15: {
                    CloseableHttpClient httpClient = Optional.ofNullable(this.httpClient).orElseGet(HttpClients::createDefault);
                    try {
                        CloseableHttpResponse httpResponse;
                        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
                        RequestConfig defaultRequestConfig = requestConfigBuilder.build();
                        String uri = this.buildUrl(URL2, params.get(URI_PARAMETERS));
                        method = new HttpPost(uri);
                        method.setConfig(defaultRequestConfig);
                        if (StringUtils.isNotBlank((CharSequence)entry)) {
                            method.setEntity((HttpEntity)new StringEntity(entry));
                        }
                        this.setHeaderParams(method, params);
                        this.configureProxy((HttpRequestBase)method, defaultRequestConfig);
                        if (log.isDebugEnabled()) {
                            log.debug("Performing POST request to \"" + uri + "\"...");
                        }
                        if (this.isNotSuccessfull((HttpResponse)(httpResponse = httpClient.execute((HttpUriRequest)method)))) {
                            throw new RuntimeException();
                        }
                        InputStream inputStream = httpResponse.getEntity().getContent();
                        string = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
                        if (httpClient == null) break block15;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (httpClient != null) {
                                try {
                                    httpClient.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e1) {
                            log.error(e1.getMessage(), (Throwable)e1);
                            break block16;
                        }
                    }
                    httpClient.close();
                }
                return string;
            }
            finally {
                if (Objects.nonNull(method)) {
                    method.releaseConnection();
                }
            }
        }
        return "";
    }

    private void configureProxy(HttpRequestBase method, RequestConfig defaultRequestConfig) {
        String proxyHost = this.configurationService.getProperty("http.proxy.host");
        String proxyPort = this.configurationService.getProperty("http.proxy.port");
        if (StringUtils.isNotBlank((CharSequence)proxyHost) && StringUtils.isNotBlank((CharSequence)proxyPort)) {
            RequestConfig requestConfig = RequestConfig.copy((RequestConfig)defaultRequestConfig).setProxy(new HttpHost(proxyHost, Integer.parseInt(proxyPort), "http")).build();
            method.setConfig(requestConfig);
        }
    }

    private void setHeaderParams(HttpPost method, Map<String, Map<String, String>> params) {
        Map<String, String> headerParams = params.get(HEADER_PARAMETERS);
        if (MapUtils.isNotEmpty(headerParams)) {
            for (String param : headerParams.keySet()) {
                method.setHeader(param, headerParams.get(param));
            }
        }
    }

    private String buildUrl(String URL2, Map<String, String> requestParams) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(URL2);
        if (MapUtils.isNotEmpty(requestParams)) {
            for (String param : requestParams.keySet()) {
                uriBuilder.setParameter(param, requestParams.get(param));
            }
        }
        return uriBuilder.toString();
    }

    private boolean isNotSuccessfull(HttpResponse response) {
        int statusCode = this.getStatusCode(response);
        return statusCode < 200 || statusCode > 299;
    }

    private int getStatusCode(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

