/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo.client;

import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.dspace.matomo.client.MatomoAbstractClient;
import org.dspace.matomo.client.MatomoRequestBuilder;
import org.dspace.matomo.client.MatomoResponseReader;

public class MatomoAsyncClientImpl
extends MatomoAbstractClient<HttpClient, HttpRequest, HttpResponse<String>> {
    public MatomoAsyncClientImpl(String baseUrl, String token, MatomoRequestBuilder matomoRequestBuilder, MatomoResponseReader matomoResponseReader) {
        this(baseUrl, token, matomoRequestBuilder, matomoResponseReader, HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofSeconds(5L)).proxy(ProxySelector.getDefault()).build());
    }

    public MatomoAsyncClientImpl(String baseUrl, String token, MatomoRequestBuilder matomoRequestBuilder, MatomoResponseReader matomoResponseReader, HttpClient httpClient) {
        super(baseUrl, token, matomoRequestBuilder, matomoResponseReader, httpClient);
    }

    @Override
    protected HttpRequest createRequest(String requestBody, String cookies) {
        return HttpRequest.newBuilder(URI.create(this.baseUrl)).POST(HttpRequest.BodyPublishers.ofString(requestBody)).setHeader("Content-Type", "application/json").setHeader("Cookie", cookies).build();
    }

    @Override
    protected void executeRequest(String requestBody, String cookies, BiConsumer<HttpResponse<String>, String> responseConsumer) {
        ((CompletableFuture)((HttpClient)this.httpClient).sendAsync(this.createRequest(requestBody, cookies), HttpResponse.BodyHandlers.ofString()).thenAccept(response -> responseConsumer.accept((HttpResponse<String>)response, requestBody))).exceptionally(this::logError);
    }

    private Void logError(Throwable throwable) {
        this.log.error("Cannot track this request to Matomo! Check the matomo.tracking.url configured. ", throwable);
        return null;
    }

    @Override
    protected int getStatusCode(HttpResponse<String> response) {
        return response.statusCode();
    }

    @Override
    protected String getResponseContent(HttpResponse<String> response) {
        try {
            return response.body();
        }
        catch (Exception e) {
            this.log.error("An error occurs getting the response content", (Throwable)e);
            return "Generic error";
        }
    }
}

