/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo.factory;

import jakarta.servlet.http.Cookie;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.dspace.matomo.factory.MatomoRequestDetailsEnricher;
import org.dspace.matomo.model.MatomoRequestDetails;
import org.dspace.usage.UsageEvent;

public class MatomoRequestCustomVariablesEnricher
implements MatomoRequestDetailsEnricher {
    public static final String VARIABLE_PATTERN = "\"{0}\":[\"{1}\",\"{2}\"]";
    public static final String PK_CVAR = "_pk_cvar";

    @Override
    public MatomoRequestDetails enrich(UsageEvent usageEvent, MatomoRequestDetails matomoRequestDetails) {
        Cookie[] cookies = usageEvent.getRequest().getCookies();
        if (cookies == null) {
            return matomoRequestDetails;
        }
        for (Cookie cookie : cookies) {
            String cookieName = cookie.getName();
            String baseName = null;
            if (cookieName != null && cookieName.contains(".")) {
                baseName = cookieName.substring(0, cookieName.indexOf("."));
            }
            if (baseName == null || !baseName.toLowerCase(Locale.ROOT).startsWith(PK_CVAR)) continue;
            return MatomoRequestCustomVariablesEnricher.addCustomVariables(matomoRequestDetails, cookie.getValue());
        }
        return matomoRequestDetails;
    }

    private static MatomoRequestDetails addCustomVariables(MatomoRequestDetails matomoRequestDetails, String customVariables) {
        Map<Integer, Map.Entry<String, String>> parsedCustomVariables = MatomoRequestCustomVariablesEnricher.parse(customVariables);
        if (parsedCustomVariables == null) {
            return matomoRequestDetails;
        }
        String variables = parsedCustomVariables.entrySet().stream().map(entry -> MessageFormat.format(VARIABLE_PATTERN, entry.getKey(), ((Map.Entry)entry.getValue()).getKey(), ((Map.Entry)entry.getValue()).getValue())).collect(Collectors.joining(","));
        if (variables.isEmpty()) {
            return matomoRequestDetails;
        }
        return matomoRequestDetails.addParameter("_cvar", "{" + variables + "}");
    }

    public static Map<Integer, Map.Entry<String, String>> parse(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(value, ":{}\"");
        Integer key = null;
        String customVariableKey = null;
        String customVariableValue = null;
        HashMap<Integer, Map.Entry<String, String>> parsedVariables = new HashMap<Integer, Map.Entry<String, String>>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.isEmpty()) continue;
            if (token.matches("\\d+")) {
                key = Integer.parseInt(token);
                continue;
            }
            if (token.startsWith("[") && key != null) {
                customVariableKey = tokenizer.nextToken();
                tokenizer.nextToken();
                customVariableValue = tokenizer.nextToken();
                continue;
            }
            if (key != null && customVariableKey != null && customVariableValue != null) {
                parsedVariables.put(key, Map.entry(customVariableKey, customVariableValue));
                continue;
            }
            if (!token.equals(",")) continue;
            key = null;
            customVariableKey = null;
            customVariableValue = null;
        }
        return parsedVariables;
    }
}

