/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo.model;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dspace.matomo.model.MatomoRequestDetails;

public class MatomoCookieConverter {
    private MatomoCookieConverter() {
    }

    public static String convert(MatomoRequestDetails matomoRequestDetails) {
        return matomoRequestDetails.cookies.entrySet().stream().map(entry -> MessageFormat.format("{0}={1}", entry.getKey(), entry.getValue())).collect(Collectors.joining(";"));
    }

    public static String convert(List<MatomoRequestDetails> matomoRequestDetails) {
        if (matomoRequestDetails == null || matomoRequestDetails.isEmpty()) {
            return "";
        }
        Map<String, String> reducedCookies = matomoRequestDetails.stream().flatMap(details -> details.cookies.entrySet().stream()).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.reducing("", (a, b) -> b))));
        return reducedCookies.entrySet().stream().map(entry -> MessageFormat.format("{0}={1}", entry.getKey(), entry.getValue())).collect(Collectors.joining(";"));
    }
}

