/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sort;

import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.sort.OrderFormatAuthor;
import org.dspace.sort.OrderFormatDate;
import org.dspace.sort.OrderFormatDelegate;
import org.dspace.sort.OrderFormatText;
import org.dspace.sort.OrderFormatTitle;

public class OrderFormat {
    public static final String AUTHOR = "author";
    public static final String TITLE = "title";
    public static final String TEXT = "text";
    public static final String DATE = "date";
    public static final String AUTHORITY = "authority";
    private static final String[] delegates = CoreServiceFactory.getInstance().getPluginService().getAllPluginNames(OrderFormatDelegate.class);
    private static final OrderFormatDelegate authorDelegate = new OrderFormatAuthor();
    private static final OrderFormatDelegate titleDelegate = new OrderFormatTitle();
    private static final OrderFormatDelegate textDelegate = new OrderFormatText();
    private static final OrderFormatDelegate dateDelegate = new OrderFormatDate();
    private static final OrderFormatDelegate authorityDelegate = new OrderFormatText();

    private OrderFormat() {
    }

    public static String makeSortString(String value, String language, String type) {
        OrderFormatDelegate delegate = null;
        if (value == null) {
            return null;
        }
        if (type != null && type.length() > 0) {
            delegate = OrderFormat.getDelegate(type);
            if (delegate != null) {
                return delegate.makeSortString(value, language);
            }
            if (type.equalsIgnoreCase(AUTHOR)) {
                return authorDelegate.makeSortString(value, language);
            }
            if (type.equalsIgnoreCase(TITLE)) {
                return titleDelegate.makeSortString(value, language);
            }
            if (type.equalsIgnoreCase(TEXT)) {
                return textDelegate.makeSortString(value, language);
            }
            if (type.equalsIgnoreCase(DATE)) {
                return dateDelegate.makeSortString(value, language);
            }
            if (type.equalsIgnoreCase(AUTHORITY)) {
                return authorityDelegate.makeSortString(value, language);
            }
        }
        return value;
    }

    private static OrderFormatDelegate getDelegate(String name) {
        if (name != null && name.length() > 0) {
            for (int idx = 0; idx < delegates.length; ++idx) {
                if (!delegates[idx].equals(name)) continue;
                return (OrderFormatDelegate)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(OrderFormatDelegate.class, name);
            }
        }
        return null;
    }
}

