/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IPTable {
    private static final Logger log = LogManager.getLogger(IPTable.class);
    private final Set<IPRange> ipRanges = new HashSet<IPRange>();

    public void add(String ip) throws IPFormatException {
        String[] range = ip.split("-");
        if (range.length == 2) {
            String start = range[0].trim();
            String end = range[1].trim();
            try {
                long ipLo = IPTable.ipToLong(InetAddress.getByName(start));
                long ipHi = IPTable.ipToLong(InetAddress.getByName(end));
                this.ipRanges.add(new IPRange(ipLo, ipHi));
                return;
            }
            catch (UnknownHostException e) {
                throw new IPFormatException(ip + " - Range format should be similar to 1.2.3.0-1.2.3.255");
            }
        }
        int periods = StringUtils.countMatches((CharSequence)ip, (char)'.');
        if (periods < 3) {
            ip = StringUtils.join((Object[])new Serializable[]{ip, StringUtils.repeat((String)".0", (int)(4 - periods - 1)), "/", Integer.valueOf((periods + 1) * 8)});
        }
        if (ip.contains("/")) {
            String[] parts = ip.split("/");
            try {
                long ipLong = IPTable.ipToLong(InetAddress.getByName(parts[0]));
                long mask = (long)Math.pow(2.0, 32 - Integer.parseInt(parts[1]));
                long ipLo = ipLong / mask * mask;
                long ipHi = (ipLong / mask + 1L) * mask - 1L;
                this.ipRanges.add(new IPRange(ipLo, ipHi));
                return;
            }
            catch (Exception e) {
                throw new IPFormatException(ip + " - Range format should be similar to 172.16.0.0/12");
            }
        }
        try {
            long ipLo = IPTable.ipToLong(InetAddress.getByName(ip));
            this.ipRanges.add(new IPRange(ipLo, ipLo));
            return;
        }
        catch (UnknownHostException e) {
            throw new IPFormatException(ip + " - IP address format should be similar to 1.2.3.14");
        }
    }

    public static long ipToLong(InetAddress ip) {
        byte[] octets = ip.getAddress();
        long result = 0L;
        for (byte octet : octets) {
            result <<= 8;
            result |= (long)(octet & 0xFF);
        }
        return result;
    }

    public static String longToIp(long ip) {
        long part = ip;
        String[] parts = new String[4];
        for (int i = 0; i < 4; ++i) {
            long octet = part & 0xFFL;
            parts[3 - i] = String.valueOf(octet);
            part /= 256L;
        }
        return parts[0] + "." + parts[1] + "." + parts[2] + "." + parts[3];
    }

    public boolean contains(String ip) throws IPFormatException {
        if (null == ip) {
            throw new IPFormatException("Address may not be null");
        }
        try {
            long ipToTest = IPTable.ipToLong(InetAddress.getByName(ip));
            return this.ipRanges.stream().anyMatch(ipRange -> ipToTest >= ipRange.getIpLo() && ipToTest <= ipRange.getIpHi());
        }
        catch (UnknownHostException e) {
            throw new IPFormatException("ip not valid");
        }
    }

    public Set<String> toSet() {
        HashSet<String> set = new HashSet<String>();
        for (IPRange ipRange : this.ipRanges) {
            long ipLo = ipRange.getIpLo();
            long ipHi = ipRange.getIpHi();
            for (long ip = ipLo; ip <= ipHi; ++ip) {
                set.add(IPTable.longToIp(ip));
            }
        }
        return set;
    }

    public boolean isEmpty() {
        return this.ipRanges.isEmpty();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<IPRange> ipRangeIterator = this.ipRanges.iterator();
        while (ipRangeIterator.hasNext()) {
            IPRange ipRange = ipRangeIterator.next();
            stringBuilder.append(IPTable.longToIp(ipRange.getIpLo())).append("-").append(IPTable.longToIp(ipRange.getIpHi()));
            if (!ipRangeIterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    static class IPRange {
        private final long ipLo;
        private final long ipHi;

        IPRange(long ipLo, long ipHi) {
            this.ipLo = ipLo;
            this.ipHi = ipHi;
        }

        public long getIpLo() {
            return this.ipLo;
        }

        public long getIpHi() {
            return this.ipHi;
        }
    }

    public static class IPFormatException
    extends Exception {
        public IPFormatException(String s) {
            super(s);
        }
    }
}

