/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.dspace.services.ConfigurationService;
import org.springframework.util.Assert;

public class SimpleMapConverter {
    private String converterNameFile;
    private ConfigurationService configurationService;
    private Map<String, String> mapping;
    private String defaultValue = "";

    public void init() {
        Assert.notNull((Object)this.converterNameFile, (String)"No properties file name provided");
        Assert.notNull((Object)this.configurationService, (String)"No configuration service provided");
        String mappingFile = this.configurationService.getProperty("dspace.dir") + File.separator + "config" + File.separator + "crosswalks" + File.separator + this.converterNameFile;
        try (FileInputStream fis = new FileInputStream(new File(mappingFile));){
            Properties mapConfig = new Properties();
            mapConfig.load(fis);
            this.mapping = this.parseProperties(mapConfig);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("An error occurs parsing " + mappingFile, e);
        }
    }

    public String getValue(String key) {
        String value = this.mapping.getOrDefault(key, this.defaultValue);
        if (StringUtils.isBlank((CharSequence)value)) {
            return key;
        }
        return value;
    }

    private Map<String, String> parseProperties(Properties properties) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (Object key : properties.keySet()) {
            String keyString = (String)key;
            mapping.put(keyString, properties.getProperty(keyString, ""));
        }
        return mapping;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setConverterNameFile(String converterNameFile) {
        this.converterNameFile = converterNameFile;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

