/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.storedcomponents;

import java.sql.SQLException;
import java.util.List;
import org.dspace.content.Collection;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.xmlworkflow.storedcomponents.CollectionRole;
import org.dspace.xmlworkflow.storedcomponents.dao.CollectionRoleDAO;
import org.dspace.xmlworkflow.storedcomponents.service.CollectionRoleService;
import org.springframework.beans.factory.annotation.Autowired;

public class CollectionRoleServiceImpl
implements CollectionRoleService {
    @Autowired(required=true)
    protected CollectionRoleDAO collectionRoleDAO;

    protected CollectionRoleServiceImpl() {
    }

    @Override
    public CollectionRole find(Context context, int id) throws SQLException {
        return (CollectionRole)this.collectionRoleDAO.findByID(context, CollectionRole.class, id);
    }

    @Override
    public CollectionRole find(Context context, Collection collection, String role) throws SQLException {
        return this.collectionRoleDAO.findByCollectionAndRole(context, collection, role);
    }

    @Override
    public List<CollectionRole> findByCollection(Context context, Collection collection) throws SQLException {
        return this.collectionRoleDAO.findByCollection(context, collection);
    }

    @Override
    public List<CollectionRole> findByGroup(Context context, Group group) throws SQLException {
        return this.collectionRoleDAO.findByGroup(context, group);
    }

    @Override
    public CollectionRole create(Context context, Collection collection, String roleId, Group group) throws SQLException {
        CollectionRole collectionRole = this.collectionRoleDAO.create(context, new CollectionRole());
        collectionRole.setCollection(collection);
        collectionRole.setRoleId(roleId);
        collectionRole.setGroup(group);
        this.update(context, collectionRole);
        return collectionRole;
    }

    @Override
    public void update(Context context, CollectionRole collectionRole) throws SQLException {
        this.collectionRoleDAO.save(context, collectionRole);
    }

    @Override
    public void delete(Context context, CollectionRole collectionRole) throws SQLException {
        this.collectionRoleDAO.delete(context, collectionRole);
    }

    @Override
    public void deleteByCollection(Context context, Collection collection) throws SQLException {
        this.collectionRoleDAO.deleteByCollection(context, collection);
    }
}

