/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sherpa;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.dspace.AbstractDSpaceTest;
import org.dspace.app.sherpa.MockSHERPAService;
import org.dspace.app.sherpa.SHERPAService;
import org.dspace.app.sherpa.v2.SHERPAJournal;
import org.dspace.app.sherpa.v2.SHERPAPublisher;
import org.dspace.app.sherpa.v2.SHERPAPublisherPolicy;
import org.dspace.app.sherpa.v2.SHERPAPublisherResponse;
import org.dspace.app.sherpa.v2.SHERPAResponse;
import org.dspace.app.sherpa.v2.SHERPAUtils;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SHERPAServiceTest
extends AbstractDSpaceTest {
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    protected SHERPAService sherpaService = (SHERPAService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName("org.dspace.app.sherpa.MockSHERPAService", MockSHERPAService.class);

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSearchByJournalISSN() {
        String validISSN = "0140-6736";
        SHERPAResponse sherpaResponse = this.sherpaService.searchByJournalISSN(validISSN);
        Assert.assertFalse((String)("Response contained an error flag / message: " + sherpaResponse.getMessage()), (boolean)sherpaResponse.isError());
        String expectedTitle = "The Lancet";
        Assert.assertTrue((String)("Response did not contain a journal with the expected title '" + expectedTitle + "\""), (boolean)expectedTitle.equals(((SHERPAJournal)sherpaResponse.getJournals().get(0)).getTitles().get(0)));
    }

    @Test
    public void testUriConstruction() throws URISyntaxException, UnsupportedEncodingException {
        String endpoint = this.configurationService.getProperty("sherpa.romeo.url", "https://v2.sherpa.ac.uk/cgi/retrieve");
        String apiKey = this.configurationService.getProperty("sherpa.romeo.apikey", null);
        String validISSN = "0140-6736";
        String invalidISSN = "{TEST}";
        Assert.assertEquals((String)"JSON filter query sanitisation not stripping special characters", (Object)"TEST", (Object)SHERPAUtils.sanitiseQuery((String)invalidISSN));
        String validUrl = new URIBuilder(SHERPAServiceTest.buildUrlString(validISSN, endpoint, apiKey)).toString();
        Assert.assertEquals((String)"Built and expected valid URLs differ", (Object)validUrl, (Object)this.sherpaService.constructHttpGet("publication", "issn", "equals", validISSN).getURI().toASCIIString());
        String invalidUrl = new URIBuilder(SHERPAServiceTest.buildUrlString(invalidISSN, endpoint, apiKey)).toString();
        Assert.assertEquals((String)"Built and expected invalid URLs differ", (Object)invalidUrl, (Object)this.sherpaService.constructHttpGet("publication", "issn", "equals", invalidISSN).getURI().toASCIIString());
        String nullUrl = new URIBuilder(SHERPAServiceTest.buildUrlString(null, endpoint, apiKey)).toString();
        Assert.assertEquals((String)"Built and expected invalid URLs differ", (Object)nullUrl, (Object)this.sherpaService.constructHttpGet("publication", "issn", "equals", null).getURI().toASCIIString());
    }

    @Test
    public void testJournalResponse() {
        String validISSN = "0140-6736";
        SHERPAResponse response = this.sherpaService.searchByJournalISSN(validISSN);
        Assert.assertFalse((String)"Response was flagged as 'isError'", (boolean)response.isError());
        Assert.assertTrue((String)"List of journals did not contain at least one parsed journal", (boolean)CollectionUtils.isNotEmpty((Collection)response.getJournals()));
        String expectedTitle = "The Lancet";
        Assert.assertTrue((String)("Journal title did not match expected '" + expectedTitle + "' value"), (CollectionUtils.isNotEmpty((Collection)((SHERPAJournal)response.getJournals().get(0)).getTitles()) && expectedTitle.equals(((SHERPAJournal)response.getJournals().get(0)).getTitles().get(0)) ? 1 : 0) != 0);
        String expectedSystemMetadataUri = "http://v2.sherpa.ac.uk/id/publication/23803";
        Assert.assertTrue((String)("Response metadata URI did not match expected '" + expectedSystemMetadataUri + "' value"), (boolean)expectedSystemMetadataUri.equals(response.getMetadata().getUri()));
        Assert.assertTrue((String)"Response did not contain at least one archiving policy", (boolean)CollectionUtils.isNotEmpty((Collection)((SHERPAJournal)response.getJournals().get(0)).getPolicies()));
        Assert.assertTrue((String)"Response did not contain at least one permitted version", (boolean)CollectionUtils.isNotEmpty((Collection)((SHERPAPublisherPolicy)((SHERPAJournal)response.getJournals().get(0)).getPolicies().get(0)).getPermittedVersions()));
        Assert.assertTrue((String)"Response did not contain at least one publisher", (boolean)CollectionUtils.isNotEmpty((Collection)((SHERPAJournal)response.getJournals().get(0)).getPublishers()));
        String expectedPublisherName = "Elsevier";
        Assert.assertTrue((String)("Response did not contain expected publisher name '" + expectedPublisherName + "'"), (boolean)expectedPublisherName.equals(((SHERPAJournal)response.getJournals().get(0)).getPublisher().getName()));
    }

    @Test
    public void testPublisherResponse() {
        String publisherName = "Public Library of Science";
        SHERPAPublisherResponse response = this.sherpaService.performPublisherRequest("publisher", "name", "equals", publisherName, 0, 1);
        Assert.assertFalse((String)"Response was flagged as 'isError'", (boolean)response.isError());
        Assert.assertTrue((String)"List of publishers did not contain at least one parsed publisher", (boolean)CollectionUtils.isNotEmpty((Collection)response.getPublishers()));
        String expectedName = "Public Library of Science";
        Assert.assertEquals((String)("Publisher name did not match expected '" + expectedName + "' value"), (Object)expectedName, (Object)((SHERPAPublisher)response.getPublishers().get(0)).getName());
        String expectedUrl = "http://www.plos.org/";
        Assert.assertEquals((String)("Response metadata URI did not match expected '" + expectedUrl + "' value"), (Object)expectedUrl, (Object)((SHERPAPublisher)response.getPublishers().get(0)).getUri());
        String expectedId = "112";
        Assert.assertEquals((String)("Response publisher ID did not match expected ID " + expectedId), (Object)expectedId, (Object)((SHERPAPublisher)response.getPublishers().get(0)).getIdentifier());
    }

    public static String buildUrlString(String query, String endpoint, String apiKey) {
        query = SHERPAUtils.sanitiseQuery((String)query);
        StringBuilder expected = new StringBuilder();
        String filter = "[[\"issn\",\"equals\",\"" + query + "\"]]";
        expected.append(endpoint).append("?").append("item-type=publication&filter=").append(URLEncoder.encode(filter, StandardCharsets.UTF_8)).append("&format=Json&offset=0&limit=1");
        if (StringUtils.isNotBlank((CharSequence)apiKey)) {
            expected.append("&api-key=").append(apiKey);
        }
        return expected.toString();
    }
}

