/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import org.dspace.AbstractDSpaceTest;
import org.dspace.browse.CrossLinks;
import org.dspace.services.ConfigurationService;
import org.dspace.utils.DSpace;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CrossLinksTest
extends AbstractDSpaceTest {
    protected ConfigurationService configurationService;

    @Before
    public void setUp() {
        this.configurationService = new DSpace().getConfigurationService();
    }

    @Test
    public void testFindLinkType_Null() throws Exception {
        CrossLinks crossLinks = new CrossLinks();
        Assert.assertNull((Object)crossLinks.findLinkType(null));
    }

    @Test
    public void testFindLinkType_NoMatch() throws Exception {
        CrossLinks crossLinks = new CrossLinks();
        String metadataField = "foo.bar.baz.does.not.exist";
        Assert.assertNull((Object)crossLinks.findLinkType(metadataField));
    }

    @Test
    public void testFindLinkType_WildcardMatch() throws Exception {
        this.configurationService.setProperty("webui.browse.link.1", (Object)"author:dc.contributor.*");
        CrossLinks crossLinks = new CrossLinks();
        String metadataField = "dc.contributor.author";
        Assert.assertEquals((Object)"author", (Object)crossLinks.findLinkType(metadataField));
    }

    @Test
    public void testFindLinkType_SingleExactMatch_Author() throws Exception {
        this.configurationService.setProperty("webui.browse.link.1", (Object)"author:dc.contributor.author");
        CrossLinks crossLinks = new CrossLinks();
        Assert.assertEquals((Object)"type", (Object)crossLinks.findLinkType("dc.genre"));
        Assert.assertEquals((Object)"author", (Object)crossLinks.findLinkType("dc.contributor.author"));
    }

    @Test
    public void testFindLinkType_SingleExactMatch_Type() throws Exception {
        this.configurationService.setProperty("webui.browse.link.1", (Object)"type:dc.genre");
        CrossLinks crossLinks = new CrossLinks();
        Assert.assertEquals((Object)"type", (Object)crossLinks.findLinkType("dc.genre"));
    }

    @Test
    public void testFindLinkType_MultipleExactMatches_DifferentIndexes() throws Exception {
        this.configurationService.setProperty("webui.browse.link.1", (Object)"author:dc.contributor.author");
        this.configurationService.setProperty("webui.browse.link.2", (Object)"type:dc.genre");
        CrossLinks crossLinks = new CrossLinks();
        Assert.assertEquals((Object)"author", (Object)crossLinks.findLinkType("dc.contributor.author"));
        Assert.assertEquals((Object)"type", (Object)crossLinks.findLinkType("dc.genre"));
    }

    @Test
    public void testFindLinkType_MultipleWildcardMatches_DifferentIndexes() throws Exception {
        this.configurationService.setProperty("webui.browse.link.1", (Object)"author:dc.contributor.*");
        this.configurationService.setProperty("webui.browse.link.2", (Object)"subject:dc.subject.*");
        CrossLinks crossLinks = new CrossLinks();
        Assert.assertEquals((Object)"author", (Object)crossLinks.findLinkType("dc.contributor.author"));
        Assert.assertEquals((Object)"subject", (Object)crossLinks.findLinkType("dc.subject.lcsh"));
    }

    @Test
    public void testFindLinkType_MultiplExactAndWildcardMatches_DifferentIndexes() throws Exception {
        this.configurationService.setProperty("webui.browse.link.1", (Object)"author:dc.contributor.*");
        this.configurationService.setProperty("webui.browse.link.2", (Object)"subject:dc.subject.*");
        this.configurationService.setProperty("webui.browse.link.3", (Object)"type:dc.genre");
        this.configurationService.setProperty("webui.browse.link.4", (Object)"dateissued:dc.date.issued");
        CrossLinks crossLinks = new CrossLinks();
        Assert.assertEquals((Object)"author", (Object)crossLinks.findLinkType("dc.contributor.author"));
        Assert.assertEquals((Object)"subject", (Object)crossLinks.findLinkType("dc.subject.lcsh"));
        Assert.assertEquals((Object)"type", (Object)crossLinks.findLinkType("dc.genre"));
        Assert.assertEquals((Object)"dateissued", (Object)crossLinks.findLinkType("dc.date.issued"));
    }
}

