/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.io.IOException;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractDSpaceObjectBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class GroupBuilder
extends AbstractDSpaceObjectBuilder<Group> {
    private Group group;

    protected GroupBuilder(Context context) {
        super(context);
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.setDispatcher("noindex");
            c.turnOffAuthorisationSystem();
            this.group = (Group)c.reloadEntity((ReloadableEntity)this.group);
            if (this.group != null) {
                this.delete(c, this.group);
                c.complete();
            }
        }
    }

    public static GroupBuilder createGroup(Context context) {
        GroupBuilder builder = new GroupBuilder(context);
        return builder.create(context);
    }

    public static GroupBuilder createCollectionAdminGroup(Context context, Collection collection) {
        GroupBuilder builder = new GroupBuilder(context);
        return builder.createAdminGroup(context, (DSpaceObject)collection);
    }

    public static GroupBuilder createCollectionSubmitterGroup(Context context, Collection collection) {
        GroupBuilder builder = new GroupBuilder(context);
        return builder.createSubmitterGroup(context, collection);
    }

    public static GroupBuilder createCollectionDefaultReadGroup(Context context, Collection collection, String typeOfGroupString, int defaultRead) {
        GroupBuilder builder = new GroupBuilder(context);
        return builder.createDefaultReadGroup(context, collection, typeOfGroupString, defaultRead);
    }

    public static GroupBuilder createCollectionWorkflowRoleGroup(Context context, Collection collection, String roleName) {
        GroupBuilder builder = new GroupBuilder(context);
        return builder.createWorkflowRoleGroup(context, collection, roleName);
    }

    public static GroupBuilder createCommunityAdminGroup(Context context, Community community) {
        GroupBuilder builder = new GroupBuilder(context);
        return builder.createAdminGroup(context, (DSpaceObject)community);
    }

    private GroupBuilder create(Context context) {
        this.context = context;
        try {
            this.group = groupService.create(context);
        }
        catch (Exception e) {
            return (GroupBuilder)this.handleException(e);
        }
        return this;
    }

    private GroupBuilder createAdminGroup(Context context, DSpaceObject container) {
        this.context = context;
        try {
            if (container instanceof Collection) {
                this.group = collectionService.createAdministrators(context, (Collection)container);
            } else if (container instanceof Community) {
                this.group = communityService.createAdministrators(context, (Community)container);
            } else {
                this.handleException(new IllegalArgumentException("DSpaceObject must be collection or community. Type: " + container.getType()));
            }
        }
        catch (Exception e) {
            return (GroupBuilder)this.handleException(e);
        }
        return this;
    }

    private GroupBuilder createSubmitterGroup(Context context, Collection collection) {
        this.context = context;
        try {
            this.group = collectionService.createSubmitters(context, collection);
        }
        catch (Exception e) {
            return (GroupBuilder)this.handleException(e);
        }
        return this;
    }

    private GroupBuilder createDefaultReadGroup(Context context, Collection collection, String typeOfGroupString, int defaultRead) {
        this.context = context;
        try {
            this.group = collectionService.createDefaultReadGroup(context, collection, typeOfGroupString, defaultRead);
        }
        catch (Exception e) {
            return (GroupBuilder)this.handleException(e);
        }
        return this;
    }

    private GroupBuilder createWorkflowRoleGroup(Context context, Collection collection, String roleName) {
        this.context = context;
        try {
            this.group = workflowService.createWorkflowRoleGroup(context, collection, roleName);
        }
        catch (Exception e) {
            return (GroupBuilder)this.handleException(e);
        }
        return this;
    }

    @Override
    protected DSpaceObjectService<Group> getService() {
        return groupService;
    }

    @Override
    public Group build() {
        try {
            groupService.update(this.context, (DSpaceObject)this.group);
        }
        catch (Exception e) {
            return (Group)this.handleException(e);
        }
        return this.group;
    }

    public GroupBuilder withName(String groupName) {
        try {
            groupService.setName(this.group, groupName);
        }
        catch (Exception e) {
            return (GroupBuilder)this.handleException(e);
        }
        return this;
    }

    public GroupBuilder withParent(Group parent) {
        try {
            groupService.addMember(this.context, parent, this.group);
        }
        catch (Exception e) {
            return (GroupBuilder)this.handleException(e);
        }
        return this;
    }

    public GroupBuilder addMember(EPerson eperson) {
        try {
            groupService.addMember(this.context, this.group, eperson);
        }
        catch (Exception e) {
            return (GroupBuilder)this.handleException(e);
        }
        return this;
    }

    public static void deleteGroup(UUID uuid) throws SQLException, IOException {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            Group group = (Group)groupService.find(c, uuid);
            if (group != null) {
                try {
                    groupService.delete(c, (DSpaceObject)group);
                }
                catch (AuthorizeException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            c.complete();
        }
    }
}

