/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.NotifyServiceInboundPattern;
import org.dspace.app.ldn.service.NotifyServiceInboundPatternService;
import org.dspace.builder.AbstractBuilder;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.SearchServiceException;

public class NotifyServiceInboundPatternBuilder
extends AbstractBuilder<NotifyServiceInboundPattern, NotifyServiceInboundPatternService> {
    private static final Logger log = LogManager.getLogger();
    private NotifyServiceInboundPattern notifyServiceInboundPattern;

    protected NotifyServiceInboundPatternBuilder(Context context) {
        super(context);
    }

    @Override
    protected NotifyServiceInboundPatternService getService() {
        return inboundPatternService;
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.setDispatcher("noindex");
            c.turnOffAuthorisationSystem();
            this.notifyServiceInboundPattern = (NotifyServiceInboundPattern)c.reloadEntity((ReloadableEntity)this.notifyServiceInboundPattern);
            if (this.notifyServiceInboundPattern != null) {
                this.delete(this.notifyServiceInboundPattern);
            }
            c.complete();
            indexingService.commit();
        }
    }

    @Override
    public void delete(Context c, NotifyServiceInboundPattern notifyServiceInboundPattern) throws Exception {
        if (notifyServiceInboundPattern != null) {
            this.getService().delete(c, notifyServiceInboundPattern);
        }
    }

    @Override
    public NotifyServiceInboundPattern build() {
        try {
            inboundPatternService.update(this.context, this.notifyServiceInboundPattern);
            this.context.dispatchEvents();
            indexingService.commit();
        }
        catch (SQLException | SearchServiceException e) {
            log.error((Object)e);
        }
        return this.notifyServiceInboundPattern;
    }

    public void delete(NotifyServiceInboundPattern notifyServiceInboundPattern) throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            NotifyServiceInboundPattern nsEntity = (NotifyServiceInboundPattern)c.reloadEntity((ReloadableEntity)notifyServiceInboundPattern);
            if (nsEntity != null) {
                this.getService().delete(c, nsEntity);
            }
            c.complete();
        }
        indexingService.commit();
    }

    public static NotifyServiceInboundPatternBuilder createNotifyServiceInboundPatternBuilder(Context context, NotifyServiceEntity service) {
        NotifyServiceInboundPatternBuilder notifyServiceBuilder = new NotifyServiceInboundPatternBuilder(context);
        return notifyServiceBuilder.create(context, service);
    }

    private NotifyServiceInboundPatternBuilder create(Context context, NotifyServiceEntity service) {
        try {
            this.context = context;
            this.notifyServiceInboundPattern = inboundPatternService.create(context, service);
        }
        catch (SQLException e) {
            log.warn("Failed to create the NotifyService", (Throwable)e);
        }
        return this;
    }

    public NotifyServiceInboundPatternBuilder isAutomatic(boolean automatic) {
        this.notifyServiceInboundPattern.setAutomatic(automatic);
        return this;
    }

    public NotifyServiceInboundPatternBuilder withPattern(String pattern) {
        this.notifyServiceInboundPattern.setPattern(pattern);
        return this;
    }

    public NotifyServiceInboundPatternBuilder withConstraint(String constraint) {
        this.notifyServiceInboundPattern.setConstraint(constraint);
        return this;
    }
}

