/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.SolrServerException;
import org.dspace.app.suggestion.SolrSuggestionStorageService;
import org.dspace.app.suggestion.Suggestion;
import org.dspace.app.suggestion.SuggestionEvidence;
import org.dspace.app.suggestion.SuggestionTarget;
import org.dspace.builder.AbstractBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.dto.MetadataValueDTO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;

public class SuggestionTargetBuilder
extends AbstractBuilder<SuggestionTarget, SolrSuggestionStorageService> {
    public static final String EVIDENCE_MOCK_NAME = "MockEvidence";
    public static final String EVIDENCE_MOCK_NOTE = "Generated for testing purpose...";
    private Item item;
    private SuggestionTarget target;
    private List<Suggestion> suggestions;
    private String source;
    private int total;

    protected SuggestionTargetBuilder(Context context) {
        super(context);
    }

    public static SuggestionTargetBuilder createTarget(Context context, Collection col, String name) {
        return SuggestionTargetBuilder.createTarget(context, col, name, null);
    }

    public static SuggestionTargetBuilder createTarget(Context context, Collection col, String name, EPerson eperson) {
        SuggestionTargetBuilder builder = new SuggestionTargetBuilder(context);
        return builder.create(context, col, name, eperson);
    }

    public static SuggestionTargetBuilder createTarget(Context context, Item item) {
        SuggestionTargetBuilder builder = new SuggestionTargetBuilder(context);
        return builder.create(context, item);
    }

    private SuggestionTargetBuilder create(Context context, Collection col, String name) {
        return this.create(context, col, name, null);
    }

    private SuggestionTargetBuilder create(Context context, Collection col, String name, EPerson eperson) {
        this.context = context;
        try {
            ItemBuilder itemBuilder = ItemBuilder.createItem(context, col).withTitle(name);
            if (eperson != null) {
                itemBuilder = itemBuilder.withDSpaceObjectOwner(eperson.getFullName(), eperson.getID().toString());
            }
            this.item = itemBuilder.build();
            context.dispatchEvents();
            indexingService.commit();
        }
        catch (Exception e) {
            return (SuggestionTargetBuilder)this.handleException(e);
        }
        return this;
    }

    private SuggestionTargetBuilder create(Context context, Item item) {
        this.context = context;
        this.item = item;
        return this;
    }

    public SuggestionTargetBuilder withSuggestionCount(String source, int total) {
        this.source = source;
        this.total = total;
        return this;
    }

    @Override
    public SuggestionTarget build() {
        this.target = new SuggestionTarget(this.item);
        this.target.setTotal(this.total);
        this.target.setSource(this.source);
        this.suggestions = this.generateAllSuggestion();
        try {
            for (Suggestion s : this.suggestions) {
                solrSuggestionService.addSuggestion(s, false, false);
            }
            solrSuggestionService.commit();
        }
        catch (IOException | SolrServerException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return this.target;
    }

    @Override
    public void cleanup() throws Exception {
        solrSuggestionService.deleteTarget(this.target);
    }

    @Override
    protected SolrSuggestionStorageService getService() {
        return solrSuggestionService;
    }

    @Override
    public void delete(Context c, SuggestionTarget dso) throws Exception {
        solrSuggestionService.deleteTarget(dso);
    }

    private List<Suggestion> generateAllSuggestion() {
        ArrayList<Suggestion> allSuggestions = new ArrayList<Suggestion>();
        for (int idx = 0; idx < this.target.getTotal(); ++idx) {
            String idPartStr = String.valueOf(idx + 1);
            Suggestion sug = new Suggestion(this.source, this.item, idPartStr);
            sug.setDisplay("Suggestion " + this.source + " " + idPartStr);
            MetadataValueDTO mTitle = new MetadataValueDTO();
            mTitle.setSchema("dc");
            mTitle.setElement("title");
            mTitle.setValue("Title Suggestion " + idPartStr);
            MetadataValueDTO mSource1 = new MetadataValueDTO();
            mSource1.setSchema("dc");
            mSource1.setElement("source");
            mSource1.setValue("Source 1");
            MetadataValueDTO mSource2 = new MetadataValueDTO();
            mSource2.setSchema("dc");
            mSource2.setElement("source");
            mSource2.setValue("Source 2");
            sug.getMetadata().add(mTitle);
            sug.getMetadata().add(mSource1);
            sug.getMetadata().add(mSource2);
            sug.setExternalSourceUri("http://localhost/api/integration/externalsources/suggestion/entryValues/" + idPartStr);
            sug.getEvidences().add(new SuggestionEvidence(EVIDENCE_MOCK_NAME, idx % 2 == 0 ? (double)(100 - idx) : (double)idx / 2.0, EVIDENCE_MOCK_NOTE));
            allSuggestions.add(sug);
        }
        return allSuggestions;
    }
}

