/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.sql.SQLException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractBuilder;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.Group;
import org.dspace.supervision.SupervisionOrder;
import org.dspace.supervision.service.SupervisionOrderService;

public class SupervisionOrderBuilder
extends AbstractBuilder<SupervisionOrder, SupervisionOrderService> {
    private static final Logger log = LogManager.getLogger(SupervisionOrderBuilder.class);
    private SupervisionOrder supervisionOrder;

    protected SupervisionOrderBuilder(Context context) {
        super(context);
    }

    public static SupervisionOrderBuilder createSupervisionOrder(Context context, Item item, Group group) {
        SupervisionOrderBuilder builder = new SupervisionOrderBuilder(context);
        return builder.create(context, item, group);
    }

    private SupervisionOrderBuilder create(Context context, Item item, Group group) {
        try {
            this.context = context;
            this.supervisionOrder = this.getService().create(context, item, group);
        }
        catch (Exception e) {
            log.error("Error in SupervisionOrderBuilder.create(..), error: ", (Throwable)e);
        }
        return this;
    }

    @Override
    public void cleanup() throws Exception {
        this.delete(this.supervisionOrder);
    }

    @Override
    public SupervisionOrder build() throws SQLException, AuthorizeException {
        try {
            this.getService().update(this.context, (Object)this.supervisionOrder);
            this.context.dispatchEvents();
            indexingService.commit();
        }
        catch (Exception e) {
            log.error("Error in SupervisionOrderBuilder.build(), error: ", (Throwable)e);
        }
        return this.supervisionOrder;
    }

    @Override
    public void delete(Context context, SupervisionOrder supervisionOrder) throws Exception {
        if (Objects.nonNull(supervisionOrder)) {
            this.getService().delete(context, (Object)supervisionOrder);
        }
    }

    @Override
    protected SupervisionOrderService getService() {
        return supervisionOrderService;
    }

    private void delete(SupervisionOrder supervisionOrder) throws Exception {
        try (Context context = new Context();){
            context.turnOffAuthorisationSystem();
            context.setDispatcher("noindex");
            SupervisionOrder attached = (SupervisionOrder)context.reloadEntity((ReloadableEntity)supervisionOrder);
            if (attached != null) {
                this.getService().delete(context, (Object)attached);
            }
            context.complete();
            indexingService.commit();
        }
    }
}

