/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.util.Arrays;
import java.util.Collections;
import java.util.NoSuchElementException;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.DiscoverResultIterator;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class DiscoverResultIteratorTest {
    private SearchService mockSearchService;
    private Context mockContext;
    private DiscoverQuery mockDiscoverQuery;
    private DiscoverResult mockDiscoverResultWithTwoItems;
    private DiscoverResult mockEmptyDiscoverResult;
    private IndexableObject mockIndexableObject1;
    private IndexableObject mockIndexableObject2;
    private Item mockItem1;
    private Item mockItem2;

    @Before
    public void setUp() throws SearchServiceException {
        this.mockSearchService = (SearchService)Mockito.mock(SearchService.class);
        this.mockContext = (Context)Mockito.mock(Context.class);
        this.mockDiscoverQuery = (DiscoverQuery)Mockito.mock(DiscoverQuery.class);
        this.mockIndexableObject1 = (IndexableObject)Mockito.mock(IndexableObject.class);
        this.mockIndexableObject2 = (IndexableObject)Mockito.mock(IndexableObject.class);
        this.mockItem1 = (Item)Mockito.mock(Item.class);
        this.mockItem2 = (Item)Mockito.mock(Item.class);
        Mockito.when((Object)this.mockIndexableObject1.getIndexedObject()).thenReturn((Object)this.mockItem1);
        Mockito.when((Object)this.mockIndexableObject2.getIndexedObject()).thenReturn((Object)this.mockItem2);
        this.mockDiscoverResultWithTwoItems = (DiscoverResult)Mockito.mock(DiscoverResult.class);
        Mockito.when((Object)this.mockDiscoverResultWithTwoItems.getIndexableObjects()).thenReturn(Arrays.asList(this.mockIndexableObject1, this.mockIndexableObject2));
        Mockito.when((Object)this.mockDiscoverResultWithTwoItems.getTotalSearchResults()).thenReturn((Object)2L);
        this.mockEmptyDiscoverResult = (DiscoverResult)Mockito.mock(DiscoverResult.class);
        Mockito.when((Object)this.mockEmptyDiscoverResult.getIndexableObjects()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.mockEmptyDiscoverResult.getTotalSearchResults()).thenReturn((Object)0L);
        Mockito.when((Object)this.mockSearchService.search((Context)ArgumentMatchers.eq((Object)this.mockContext), (DiscoverQuery)ArgumentMatchers.any(DiscoverQuery.class))).thenReturn((Object)this.mockDiscoverResultWithTwoItems).thenReturn((Object)this.mockEmptyDiscoverResult);
    }

    @Test
    public void testHasNextWithTwoResults() {
        try (MockedStatic mockedStatic = Mockito.mockStatic(SearchUtils.class);){
            mockedStatic.when(SearchUtils::getSearchService).thenReturn((Object)this.mockSearchService);
            DiscoverResultIterator iterator = new DiscoverResultIterator(this.mockContext, null, this.mockDiscoverQuery);
            Assert.assertTrue((boolean)iterator.hasNext());
            iterator.next();
            Assert.assertTrue((boolean)iterator.hasNext());
            iterator.next();
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void testHasNextWhenNoResults() throws SearchServiceException {
        try (MockedStatic mockedStatic = Mockito.mockStatic(SearchUtils.class);){
            mockedStatic.when(SearchUtils::getSearchService).thenReturn((Object)this.mockSearchService);
            Mockito.when((Object)this.mockSearchService.search((Context)ArgumentMatchers.eq((Object)this.mockContext), (DiscoverQuery)ArgumentMatchers.any(DiscoverQuery.class))).thenReturn((Object)this.mockEmptyDiscoverResult);
            DiscoverResultIterator iterator = new DiscoverResultIterator(this.mockContext, null, this.mockDiscoverQuery);
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void testReturnsTotalSearchResults() {
        try (MockedStatic mockedStatic = Mockito.mockStatic(SearchUtils.class);){
            mockedStatic.when(SearchUtils::getSearchService).thenReturn((Object)this.mockSearchService);
            DiscoverResultIterator iterator = new DiscoverResultIterator(this.mockContext, null, this.mockDiscoverQuery);
            Assert.assertEquals((long)2L, (long)iterator.getTotalSearchResults());
        }
    }

    @Test(expected=NoSuchElementException.class)
    public void testNextThrowsExceptionWhenNoMoreElements() {
        try (MockedStatic mockedStatic = Mockito.mockStatic(SearchUtils.class);){
            mockedStatic.when(SearchUtils::getSearchService).thenReturn((Object)this.mockSearchService);
            DiscoverResultIterator iterator = new DiscoverResultIterator(this.mockContext, null, this.mockDiscoverQuery);
            iterator.next();
            iterator.next();
            iterator.next();
        }
    }

    @Test
    public void testMaxResultsLimit() {
        try (MockedStatic mockedStatic = Mockito.mockStatic(SearchUtils.class);){
            mockedStatic.when(SearchUtils::getSearchService).thenReturn((Object)this.mockSearchService);
            DiscoverResultIterator iterator = new DiscoverResultIterator(this.mockContext, null, this.mockDiscoverQuery, true, 1);
            Assert.assertTrue((boolean)iterator.hasNext());
            iterator.next();
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void testWithUncacheEntitiesTrue() throws Exception {
        try (MockedStatic mockedStatic = Mockito.mockStatic(SearchUtils.class);){
            mockedStatic.when(SearchUtils::getSearchService).thenReturn((Object)this.mockSearchService);
            DiscoverResultIterator iterator = new DiscoverResultIterator(this.mockContext, null, this.mockDiscoverQuery, true, -1);
            Assert.assertTrue((boolean)iterator.hasNext());
            iterator.next();
            Assert.assertTrue((boolean)iterator.hasNext());
            iterator.next();
            Assert.assertFalse((boolean)iterator.hasNext());
            ((Context)Mockito.verify((Object)this.mockContext)).uncacheEntity((ReloadableEntity)this.mockItem1);
            ((Context)Mockito.verify((Object)this.mockContext)).uncacheEntity((ReloadableEntity)this.mockItem2);
        }
    }
}

