/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.dspace.AbstractUnitTest;
import org.dspace.eperson.InvalidReCaptchaException;
import org.dspace.eperson.factory.CaptchaServiceFactory;
import org.dspace.eperson.service.CaptchaService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AltchaCaptchaServiceTest
extends AbstractUnitTest {
    CaptchaService captchaService;
    ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    @After
    public void tearDown() {
        this.configurationService.setProperty("captcha.provider", (Object)"google");
    }

    @Before
    public void setUp() {
        this.configurationService.setProperty("captcha.provider", (Object)"altcha");
        this.configurationService.setProperty("altcha.hmac.key", (Object)"onetwothreesecret");
        this.captchaService = CaptchaServiceFactory.getInstance().getAltchaCaptchaService();
    }

    @Test
    public void testValidJSONCaptchaPayloadValidation() {
        JSONObject json = new JSONObject();
        json.put("algorithm", (Object)"SHA-256");
        json.put("salt", (Object)"dcf5eba26e");
        json.put("number", 4791);
        json.put("challenge", (Object)"0d8dd34089fdd610bd9a8857ea1fa4a5f9fe4b53f5df0c4e1eff6dc987c4d2bf");
        json.put("signature", (Object)"dfe4ec56f3d61e3a021b1c3b3ea4c7d6aea9812ab719ffe130fd386ce0b4158c");
        String payload = Base64.getEncoder().encodeToString(json.toString().getBytes(StandardCharsets.UTF_8));
        this.captchaService.processResponse(payload, "validate");
    }

    @Test(expected=InvalidReCaptchaException.class)
    public void testInvalidCaptchaPayloadValidation() {
        JSONObject json = new JSONObject();
        json.put("algorithm", (Object)"SHA-256");
        json.put("challenge", (Object)"abcdefg");
        json.put("salt", (Object)"salt123");
        json.put("number", 1);
        json.put("signature", (Object)"123123123123");
        String payload = Base64.getEncoder().encodeToString(json.toString().getBytes(StandardCharsets.UTF_8));
        this.captchaService.processResponse(payload, "validate");
        Assert.fail((String)"Invalid captcha payload should have failed with IllegalReCaptchaException");
    }
}

