/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.builder.MetadataFieldBuilder;
import org.dspace.content.MetadataField;
import org.dspace.eperson.RegistrationData;
import org.dspace.eperson.RegistrationDataMetadata;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.RegistrationDataMetadataService;
import org.dspace.eperson.service.RegistrationDataService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class RegistrationDataMetadataServiceImplIT
extends AbstractIntegrationTestWithDatabase {
    RegistrationDataMetadataService registrationDataMetadataService = EPersonServiceFactory.getInstance().getRegistrationDAtaDataMetadataService();
    RegistrationDataService registrationDataService = EPersonServiceFactory.getInstance().getRegistrationDataService();
    MetadataField metadataField;
    RegistrationData registrationData;
    RegistrationDataMetadata metadata;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.registrationData = this.registrationDataService.create(this.context);
        this.metadataField = MetadataFieldBuilder.createMetadataField(this.context, "dc", "identifier", "custom").build();
        this.context.restoreAuthSystemState();
    }

    @Override
    @After
    public void destroy() throws Exception {
        this.registrationDataService.delete(this.context, (Object)this.registrationData);
        super.destroy();
    }

    @Test
    public void testEmptyMetadataCreation() throws Exception {
        try {
            this.metadata = this.registrationDataMetadataService.create(this.context, this.registrationData, this.metadataField);
            MatcherAssert.assertThat((Object)this.metadata, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)this.metadata.getValue(), (Matcher)CoreMatchers.nullValue());
            MatcherAssert.assertThat((Object)this.metadata.getRegistrationData().getID(), (Matcher)CoreMatchers.is((Object)this.registrationData.getID()));
            MatcherAssert.assertThat((Object)this.metadata.getMetadataField(), (Matcher)CoreMatchers.is((Object)this.metadataField));
        }
        finally {
            this.registrationDataMetadataService.delete(this.context, (Object)this.metadata);
        }
    }

    @Test
    public void testValidMetadataCreation() throws Exception {
        try {
            this.metadata = this.registrationDataMetadataService.create(this.context, this.registrationData, this.metadataField, "my-identifier");
            MatcherAssert.assertThat((Object)this.metadata, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)this.metadata.getValue(), (Matcher)CoreMatchers.is((Object)"my-identifier"));
            MatcherAssert.assertThat((Object)this.metadata.getRegistrationData().getID(), (Matcher)CoreMatchers.is((Object)this.registrationData.getID()));
            MatcherAssert.assertThat((Object)this.metadata.getMetadataField(), (Matcher)CoreMatchers.is((Object)this.metadataField));
        }
        finally {
            this.registrationDataMetadataService.delete(this.context, (Object)this.metadata);
        }
    }

    @Test
    public void testExistingMetadataFieldMetadataCreation() throws Exception {
        try {
            this.metadata = this.registrationDataMetadataService.create(this.context, this.registrationData, "dc", "identifier", "other", "my-identifier");
            MatcherAssert.assertThat((Object)this.metadata, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)this.metadata.getValue(), (Matcher)CoreMatchers.is((Object)"my-identifier"));
            MatcherAssert.assertThat((Object)this.metadata.getRegistrationData().getID(), (Matcher)CoreMatchers.is((Object)this.registrationData.getID()));
        }
        finally {
            this.registrationDataMetadataService.delete(this.context, (Object)this.metadata);
        }
    }

    @Test
    public void testFindMetadata() throws Exception {
        try {
            this.metadata = this.registrationDataMetadataService.create(this.context, this.registrationData, this.metadataField);
            RegistrationDataMetadata found = (RegistrationDataMetadata)this.registrationDataMetadataService.find(this.context, this.metadata.getID().intValue());
            MatcherAssert.assertThat((Object)found.getID(), (Matcher)CoreMatchers.is((Object)this.metadata.getID()));
        }
        finally {
            this.registrationDataMetadataService.delete(this.context, (Object)this.metadata);
        }
    }

    @Test
    public void testUpdateMetadata() throws Exception {
        try {
            this.metadata = this.registrationDataMetadataService.create(this.context, this.registrationData, this.metadataField);
            this.metadata.setValue("custom-value");
            this.registrationDataMetadataService.update(this.context, (Object)this.metadata);
            RegistrationDataMetadata found = (RegistrationDataMetadata)this.registrationDataMetadataService.find(this.context, this.metadata.getID().intValue());
            MatcherAssert.assertThat((Object)found.getID(), (Matcher)CoreMatchers.is((Object)this.metadata.getID()));
            MatcherAssert.assertThat((Object)found.getValue(), (Matcher)CoreMatchers.is((Object)"custom-value"));
        }
        finally {
            this.registrationDataMetadataService.delete(this.context, (Object)this.metadata);
        }
    }

    @Test
    public void testDeleteMetadata() throws Exception {
        try {
            this.metadata = this.registrationDataMetadataService.create(this.context, this.registrationData, this.metadataField);
            RegistrationDataMetadata found = (RegistrationDataMetadata)this.registrationDataMetadataService.find(this.context, this.metadata.getID().intValue());
            MatcherAssert.assertThat((Object)found, (Matcher)CoreMatchers.notNullValue());
            this.registrationDataMetadataService.delete(this.context, (Object)this.metadata);
            found = (RegistrationDataMetadata)this.registrationDataMetadataService.find(this.context, this.metadata.getID().intValue());
            MatcherAssert.assertThat((Object)found, (Matcher)CoreMatchers.nullValue());
        }
        finally {
            this.registrationDataMetadataService.delete(this.context, (Object)this.metadata);
        }
    }
}

