/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo;

import java.util.List;
import org.dspace.AbstractUnitTest;
import org.dspace.matomo.MatomoAsyncBulkRequestHandler;
import org.dspace.matomo.client.MatomoClient;
import org.dspace.matomo.model.MatomoRequestDetails;
import org.dspace.matomo.model.MatomoRequestDetailsBuilder;
import org.dspace.usage.UsageEvent;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MatomoAsyncBulkRequestHandlerTest
extends AbstractUnitTest {
    @Mock
    MatomoRequestDetailsBuilder builder;
    @Mock
    MatomoClient matomoClient;
    MatomoAsyncBulkRequestHandler matomoAsyncDequeHandler;

    @Before
    public void setUp() throws Exception {
        this.matomoAsyncDequeHandler = new MatomoAsyncBulkRequestHandler(this.builder, this.matomoClient, 5);
    }

    @Test
    public void testNullEvent() {
        this.matomoAsyncDequeHandler.handleEvent(null);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.matomoClient});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.builder});
    }

    @Test
    public void testSingleRequestHigherCapacity() {
        UsageEvent usageEvent = (UsageEvent)Mockito.mock(UsageEvent.class);
        MatomoRequestDetails matomoRequestDetails = new MatomoRequestDetails();
        Mockito.when((Object)this.builder.build(usageEvent)).thenReturn((Object)matomoRequestDetails);
        this.matomoAsyncDequeHandler.handleEvent(usageEvent);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.matomoClient});
    }

    @Test
    public void testSingleRequestCapacity() {
        this.matomoAsyncDequeHandler = new MatomoAsyncBulkRequestHandler(this.builder, this.matomoClient, 1);
        UsageEvent usageEvent = (UsageEvent)Mockito.mock(UsageEvent.class);
        MatomoRequestDetails matomoRequestDetails = new MatomoRequestDetails();
        Mockito.when((Object)this.builder.build(usageEvent)).thenReturn((Object)matomoRequestDetails);
        this.matomoAsyncDequeHandler.handleEvent(usageEvent);
        ((MatomoClient)Mockito.verify((Object)this.matomoClient, (VerificationMode)Mockito.times((int)1))).sendDetails((List)Mockito.any(List.class));
    }

    @Test
    public void testTwoRequestsTwoCapacity() {
        this.matomoAsyncDequeHandler = new MatomoAsyncBulkRequestHandler(this.builder, this.matomoClient, 3);
        UsageEvent usageEvent = (UsageEvent)Mockito.mock(UsageEvent.class);
        MatomoRequestDetails matomoRequestDetails = new MatomoRequestDetails();
        Mockito.when((Object)this.builder.build(usageEvent)).thenReturn((Object)matomoRequestDetails);
        this.matomoAsyncDequeHandler.handleEvent(usageEvent);
        ((MatomoClient)Mockito.verify((Object)this.matomoClient, (VerificationMode)Mockito.never())).sendDetails((List)Mockito.any(List.class));
        this.matomoAsyncDequeHandler.handleEvent(usageEvent);
        ((MatomoClient)Mockito.verify((Object)this.matomoClient, (VerificationMode)Mockito.times((int)1))).sendDetails((List)Mockito.any(List.class));
        this.matomoAsyncDequeHandler.handleEvent(usageEvent);
        ((MatomoClient)Mockito.verify((Object)this.matomoClient, (VerificationMode)Mockito.times((int)1))).sendDetails((List)Mockito.any(List.class));
        this.matomoAsyncDequeHandler.handleEvent(usageEvent);
        ((MatomoClient)Mockito.verify((Object)this.matomoClient, (VerificationMode)Mockito.times((int)2))).sendDetails((List)Mockito.any(List.class));
    }

    @Test
    public void testManualSendEvents() {
        UsageEvent usageEvent = (UsageEvent)Mockito.mock(UsageEvent.class);
        MatomoRequestDetails matomoRequestDetails = new MatomoRequestDetails();
        Mockito.when((Object)this.builder.build(usageEvent)).thenReturn((Object)matomoRequestDetails);
        this.matomoAsyncDequeHandler.handleEvent(usageEvent);
        ((MatomoClient)Mockito.verify((Object)this.matomoClient, (VerificationMode)Mockito.never())).sendDetails((List)Mockito.any(List.class));
        this.matomoAsyncDequeHandler.handleEvent(usageEvent);
        ((MatomoClient)Mockito.verify((Object)this.matomoClient, (VerificationMode)Mockito.never())).sendDetails((List)Mockito.any(List.class));
        this.matomoAsyncDequeHandler.sendEvents();
        ((MatomoClient)Mockito.verify((Object)this.matomoClient, (VerificationMode)Mockito.times((int)1))).sendDetails((List)Mockito.any(List.class));
    }
}

