/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo.client;

import java.io.IOException;
import java.util.List;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.dspace.AbstractUnitTest;
import org.dspace.matomo.client.MatomoBulkRequest;
import org.dspace.matomo.client.MatomoClientImpl;
import org.dspace.matomo.client.MatomoRequestBuilder;
import org.dspace.matomo.client.MatomoResponse;
import org.dspace.matomo.client.MatomoResponseReader;
import org.dspace.matomo.exception.MatomoClientException;
import org.dspace.matomo.model.MatomoRequestDetails;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MatomoClientImplTest
extends AbstractUnitTest {
    @Mock
    CloseableHttpClient httpClient;
    @Mock
    CloseableHttpResponse response;
    @Mock
    MatomoRequestBuilder builder;
    @Mock
    MatomoResponseReader reader;
    MatomoClientImpl matomoClient;

    @Before
    public void setUp() throws Exception {
        this.matomoClient = new MatomoClientImpl("testURL", "custom-token", this.builder, this.reader, this.httpClient);
    }

    @Test
    public void testNullRequest() {
        this.matomoClient.sendDetails((List)null);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.httpClient});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.builder});
        this.matomoClient.sendDetails(new MatomoRequestDetails[0]);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.httpClient});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.builder});
    }

    @Test
    public void testEmptyRequest() {
        this.matomoClient.sendDetails(List.of());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.httpClient});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.builder});
        this.matomoClient.sendDetails(new MatomoRequestDetails[0]);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.httpClient});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.builder});
    }

    @Test
    public void testSingleRequest() throws IOException {
        MatomoRequestDetails details = new MatomoRequestDetails().addParameter("test1", "value1").addParameter("test2", "value2").addParameter("test3", "value3");
        String json = "{\"auth_token\": \"custom-token\", \"requests\": [\"?test1=value1&test2=value2&test3=value3\"]}";
        String jsonResponse = "{\"status\": \"success\", \"tracked\": 1, \"invalid\": 0, \"invalid_indices\": []}";
        Mockito.when((Object)this.builder.buildJSON((MatomoBulkRequest)Mockito.any())).thenReturn((Object)json);
        StatusLine mock = (StatusLine)Mockito.mock(StatusLine.class);
        Mockito.when((Object)mock.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)this.response.getStatusLine()).thenReturn((Object)mock);
        Mockito.when((Object)this.response.getEntity()).thenReturn((Object)new StringEntity(jsonResponse));
        Mockito.when((Object)this.reader.fromJSON(jsonResponse)).thenReturn((Object)new MatomoResponse("success", 1, 0, null));
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Mockito.any(HttpPost.class))).thenReturn((Object)this.response);
        this.matomoClient.sendDetails(List.of(details));
        ((CloseableHttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)1))).execute((HttpUriRequest)Mockito.any(HttpPost.class));
        this.matomoClient.sendDetails(new MatomoRequestDetails[]{details});
        ((CloseableHttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)2))).execute((HttpUriRequest)Mockito.any(HttpPost.class));
    }

    @Test(expected=MatomoClientException.class)
    public void testFailSingleRequest() throws IOException {
        MatomoRequestDetails details = new MatomoRequestDetails().addParameter("test1", "value1").addParameter("test2", "value2").addParameter("test3", "value3");
        String json = "{'auth_token': 'custom-token', 'requests': ['?test1=value1&test2=value2&test3=value3']}";
        StatusLine statusLine = (StatusLine)Mockito.mock(StatusLine.class);
        Mockito.when((Object)this.builder.buildJSON((MatomoBulkRequest)Mockito.any())).thenReturn((Object)json);
        Mockito.when((Object)statusLine.getStatusCode()).thenReturn((Object)500);
        Mockito.when((Object)this.response.getStatusLine()).thenReturn((Object)statusLine);
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Mockito.any(HttpPost.class))).thenReturn((Object)this.response);
        this.matomoClient.sendDetails(List.of(details));
    }

    @Test(expected=MatomoClientException.class)
    public void testExceptionRequest() throws IOException {
        MatomoRequestDetails details = new MatomoRequestDetails().addParameter("test1", "value1").addParameter("test2", "value2").addParameter("test3", "value3");
        String json = "{'auth_token': 'custom-token', 'requests': ['?test1=value1&test2=value2&test3=value3']}";
        Mockito.when((Object)this.builder.buildJSON((MatomoBulkRequest)Mockito.any())).thenReturn((Object)json);
        ((CloseableHttpClient)Mockito.doThrow(IOException.class).when((Object)this.httpClient)).execute((HttpUriRequest)Mockito.any(HttpPost.class));
        this.matomoClient.sendDetails(List.of(details));
    }
}

