/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.supervision;

import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.SupervisionOrderBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.supervision.SupervisionOrder;
import org.dspace.supervision.factory.SupervisionOrderServiceFactory;
import org.dspace.supervision.service.SupervisionOrderService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class SupervisionOrderServiceIT
extends AbstractIntegrationTestWithDatabase {
    protected SupervisionOrderService supervisionOrderService = SupervisionOrderServiceFactory.getInstance().getSupervisionOrderService();

    @Test
    public void createSupervisionOrderTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("parent community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("collection").withEntityType("Publication").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withTitle("workspace item").withIssueDate("2023-01-24").grantLicense().build();
        Item item = workspaceItem.getItem();
        EPerson userA = EPersonBuilder.createEPerson(this.context).withCanLogin(true).withEmail("userA@example.org").build();
        EPerson userB = EPersonBuilder.createEPerson(this.context).withCanLogin(true).withEmail("userB@example.org").build();
        Group groupA = GroupBuilder.createGroup(this.context).withName("group A").addMember(userA).build();
        Group groupB = GroupBuilder.createGroup(this.context).withName("group B").addMember(userB).build();
        SupervisionOrder supervisionOrderOne = SupervisionOrderBuilder.createSupervisionOrder(this.context, item, groupA).build();
        SupervisionOrder supervisionOrderTwo = SupervisionOrderBuilder.createSupervisionOrder(this.context, item, groupB).build();
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat((Object)supervisionOrderOne, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)supervisionOrderOne.getItem().getID(), (Matcher)CoreMatchers.is((Object)item.getID()));
        MatcherAssert.assertThat((Object)supervisionOrderOne.getGroup().getID(), (Matcher)CoreMatchers.is((Object)groupA.getID()));
        MatcherAssert.assertThat((Object)supervisionOrderTwo, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)supervisionOrderTwo.getItem().getID(), (Matcher)CoreMatchers.is((Object)item.getID()));
        MatcherAssert.assertThat((Object)supervisionOrderTwo.getGroup().getID(), (Matcher)CoreMatchers.is((Object)groupB.getID()));
    }

    @Test
    public void findSupervisionOrderTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("parent community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("collection").withEntityType("Publication").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withTitle("workspace item").withIssueDate("2023-01-24").grantLicense().build();
        EPerson userA = EPersonBuilder.createEPerson(this.context).withCanLogin(true).withEmail("userA@example.org").build();
        Group groupA = GroupBuilder.createGroup(this.context).withName("group A").addMember(userA).build();
        SupervisionOrder supervisionOrderOne = SupervisionOrderBuilder.createSupervisionOrder(this.context, workspaceItem.getItem(), groupA).build();
        this.context.restoreAuthSystemState();
        SupervisionOrder supervisionOrder = (SupervisionOrder)this.supervisionOrderService.find(this.context, supervisionOrderOne.getID().intValue());
        MatcherAssert.assertThat((Object)supervisionOrder, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)supervisionOrder.getID(), (Matcher)CoreMatchers.is((Object)supervisionOrderOne.getID()));
        MatcherAssert.assertThat((Object)supervisionOrder.getGroup().getID(), (Matcher)CoreMatchers.is((Object)supervisionOrderOne.getGroup().getID()));
        MatcherAssert.assertThat((Object)supervisionOrder.getItem().getID(), (Matcher)CoreMatchers.is((Object)supervisionOrderOne.getItem().getID()));
    }

    @Test
    public void findAllSupervisionOrdersTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("parent community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("collection").withEntityType("Publication").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withTitle("workspace item").withIssueDate("2023-01-24").grantLicense().build();
        WorkspaceItem workspaceItemTwo = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withTitle("workspace item two").withIssueDate("2023-01-25").grantLicense().build();
        EPerson userA = EPersonBuilder.createEPerson(this.context).withCanLogin(true).withEmail("userA@example.org").build();
        EPerson userB = EPersonBuilder.createEPerson(this.context).withCanLogin(true).withEmail("userB@example.org").build();
        Group groupA = GroupBuilder.createGroup(this.context).withName("group A").addMember(userA).build();
        Group groupB = GroupBuilder.createGroup(this.context).withName("group B").addMember(userB).build();
        SupervisionOrderBuilder.createSupervisionOrder(this.context, workspaceItem.getItem(), groupA).build();
        SupervisionOrderBuilder.createSupervisionOrder(this.context, workspaceItem.getItem(), groupB).build();
        SupervisionOrderBuilder.createSupervisionOrder(this.context, workspaceItemTwo.getItem(), groupA).build();
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat((Object)this.supervisionOrderService.findAll(this.context), (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    public void findSupervisionOrderByItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("parent community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("collection").withEntityType("Publication").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withTitle("workspace item").withIssueDate("2023-01-24").grantLicense().build();
        WorkspaceItem workspaceItemTwo = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withTitle("workspace item two").withIssueDate("2023-01-25").grantLicense().build();
        EPerson userA = EPersonBuilder.createEPerson(this.context).withCanLogin(true).withEmail("userA@example.org").build();
        Group groupA = GroupBuilder.createGroup(this.context).withName("group A").addMember(userA).build();
        Group groupB = GroupBuilder.createGroup(this.context).withName("group B").addMember(this.eperson).build();
        SupervisionOrderBuilder.createSupervisionOrder(this.context, workspaceItem.getItem(), groupA).build();
        SupervisionOrderBuilder.createSupervisionOrder(this.context, workspaceItem.getItem(), groupB).build();
        SupervisionOrderBuilder.createSupervisionOrder(this.context, workspaceItemTwo.getItem(), groupA).build();
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat((Object)this.supervisionOrderService.findByItem(this.context, workspaceItem.getItem()), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)this.supervisionOrderService.findByItem(this.context, workspaceItemTwo.getItem()), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void findSupervisionOrderByItemAndGroupTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("parent community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("collection").withEntityType("Publication").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withTitle("workspace item").withIssueDate("2023-01-24").grantLicense().build();
        Item item = workspaceItem.getItem();
        EPerson userA = EPersonBuilder.createEPerson(this.context).withCanLogin(true).withEmail("userA@example.org").build();
        Group groupA = GroupBuilder.createGroup(this.context).withName("group A").addMember(userA).build();
        Group groupB = GroupBuilder.createGroup(this.context).withName("group B").addMember(this.eperson).build();
        SupervisionOrderBuilder.createSupervisionOrder(this.context, item, groupA).build();
        this.context.restoreAuthSystemState();
        SupervisionOrder supervisionOrderA = this.supervisionOrderService.findByItemAndGroup(this.context, item, groupA);
        MatcherAssert.assertThat((Object)supervisionOrderA, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)supervisionOrderA.getItem().getID(), (Matcher)CoreMatchers.is((Object)item.getID()));
        MatcherAssert.assertThat((Object)supervisionOrderA.getGroup().getID(), (Matcher)CoreMatchers.is((Object)groupA.getID()));
        MatcherAssert.assertThat((Object)this.supervisionOrderService.findByItemAndGroup(this.context, item, groupB), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void isSupervisorTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("parent community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("collection").withEntityType("Publication").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withTitle("workspace item").withIssueDate("2023-01-24").grantLicense().build();
        EPerson userA = EPersonBuilder.createEPerson(this.context).withCanLogin(true).withEmail("userA@example.org").build();
        EPerson userB = EPersonBuilder.createEPerson(this.context).withCanLogin(true).withEmail("userB@example.org").build();
        Group groupA = GroupBuilder.createGroup(this.context).withName("group A").addMember(userA).build();
        GroupBuilder.createGroup(this.context).withName("group B").addMember(userB).build();
        SupervisionOrderBuilder.createSupervisionOrder(this.context, workspaceItem.getItem(), groupA).build();
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat((Object)this.supervisionOrderService.isSupervisor(this.context, userA, workspaceItem.getItem()), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.supervisionOrderService.isSupervisor(this.context, userB, workspaceItem.getItem()), (Matcher)CoreMatchers.is((Object)false));
    }
}

